/*
 * Decompiled with CFR 0.152.
 */
package br.gov.cgu.utils;

import br.gov.cgu.utils.exceptions.DateConversionException;
import br.gov.cgu.utils.exceptions.DatePeriodException;
import java.text.DateFormatSymbols;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class DateUtils {
    public static final String LANGUAGE = "pt";
    public static final String COUNTRY = "BR";
    public static final Locale PT_BR = new Locale("pt", "BR");
    public static final DateTimeFormatter YYYYMMDD_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DDMMYYYY_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    public static final DateTimeFormatter DDMMMMYYYY_FORMATTER = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy", PT_BR);
    public static final DateTimeFormatter DDMMYYYY_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    public static final DateTimeFormatter DDMMMMYYYY_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy '\u00e0s' HH:mm:ss", PT_BR);
    private static final DateTimeFormatter MES_ANO_FORMATTER = DateTimeFormatter.ofPattern("MM/yyyy");
    private static final String DATE_CONVERSION_EXCEPTION_MSG = "Problemas ao se realizar a convers\u00e3o de datas";
    private static final String DATE_PERIOD_EXCEPTION_MSG = "A data de inicio e a data de fim n\u00e3o podem ser nulas.";

    private DateUtils() {
    }

    public static String toString(LocalDate data) {
        return DateUtils.toString(data, DDMMYYYY_FORMATTER);
    }

    public static String toString(LocalDate data, DateTimeFormatter formato) {
        if (data == null) {
            return null;
        }
        return data.format(formato);
    }

    public static String toStringMesPorExtenso(LocalDate data) {
        if (data == null) {
            return null;
        }
        return data.format(DDMMMMYYYY_FORMATTER).toLowerCase();
    }

    public static String toString(LocalDateTime data) {
        if (data == null) {
            return null;
        }
        return data.format(DDMMYYYY_HHMMSS_FORMATTER);
    }

    public static String toStringMesPorExtenso(LocalDateTime data) {
        if (data == null) {
            return null;
        }
        return data.format(DDMMMMYYYY_HHMMSS_FORMATTER).toLowerCase();
    }

    public static String toStringMesAno(LocalDate data) {
        if (data == null) {
            return null;
        }
        return data.format(MES_ANO_FORMATTER);
    }

    public static LocalDate parseLocalDate(String data) {
        if (data != null && data.length() > 0) {
            try {
                return LocalDate.parse(data, DDMMYYYY_FORMATTER);
            }
            catch (IllegalArgumentException | DateTimeParseException ignored) {
                throw new DateConversionException(DATE_CONVERSION_EXCEPTION_MSG);
            }
        }
        return null;
    }

    public static LocalDate parseLocalDateISO(String data) {
        if (data != null && data.length() > 0) {
            try {
                return LocalDate.parse(data, YYYYMMDD_FORMATTER);
            }
            catch (IllegalArgumentException | DateTimeParseException ignored) {
                throw new DateConversionException(DATE_CONVERSION_EXCEPTION_MSG);
            }
        }
        return null;
    }

    public static LocalDate parseLocalDate(String data, DateTimeFormatter formatter) {
        if (data != null && data.length() > 0) {
            try {
                return LocalDate.parse(data, formatter);
            }
            catch (IllegalArgumentException | DateTimeParseException ignored) {
                throw new DateConversionException(DATE_CONVERSION_EXCEPTION_MSG);
            }
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(String data) {
        if (data != null && data.length() > 0) {
            try {
                return LocalDateTime.parse(data, DDMMYYYY_HHMMSS_FORMATTER);
            }
            catch (IllegalArgumentException | DateTimeParseException ignored) {
                throw new DateConversionException(DATE_CONVERSION_EXCEPTION_MSG);
            }
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTimeISO(String data) {
        if (data != null && data.length() > 0) {
            try {
                return LocalDateTime.parse(data, DateTimeFormatter.ISO_DATE_TIME);
            }
            catch (IllegalArgumentException | DateTimeParseException ignored) {
                throw new DateConversionException(DATE_CONVERSION_EXCEPTION_MSG);
            }
        }
        return null;
    }

    public static String getTextoMes(int mes) {
        if (mes < Month.JANUARY.getValue() || mes > Month.DECEMBER.getValue()) {
            throw new IllegalArgumentException("Mes deve ser numero entre 1 e 12");
        }
        return new DateFormatSymbols(PT_BR).getMonths()[mes - 1];
    }

    public static String getTextoMes(LocalDate data) {
        if (data != null) {
            return data.getMonth().getDisplayName(TextStyle.FULL, PT_BR);
        }
        throw new IllegalArgumentException("Data n\u00e3o pode ser nula");
    }

    public static boolean isFinalDeSemana(LocalDate data) {
        return data.getDayOfWeek() == DayOfWeek.SATURDAY || data.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public static Long calcularDiasUteis(LocalDate dataIni, LocalDate dataFim, Set<LocalDate> feriados) {
        if (dataIni == null || dataFim == null || feriados == null) {
            throw new IllegalArgumentException("Todos os par\u00e2metros devem ser diferentes de null.");
        }
        if (dataIni.isAfter(dataFim)) {
            throw new IllegalArgumentException("A data inicial deve ser menor ou igual a data final.");
        }
        Long diasUteis = 0L;
        LocalDate dia = dataIni;
        do {
            if (DateUtils.isFinalDeSemana(dia) || feriados.contains(dia)) continue;
            Long l = diasUteis;
            Long l2 = diasUteis = Long.valueOf(diasUteis + 1L);
        } while (!(dia = dia.plusDays(1L)).isAfter(dataFim));
        return diasUteis;
    }

    public static List<LocalDate> recuperarDiasFinalDeSemana(LocalDate dataInicio, LocalDate dataFim) {
        if (dataInicio == null || dataFim == null) {
            throw new DatePeriodException(DATE_PERIOD_EXCEPTION_MSG);
        }
        ArrayList<LocalDate> diasFinaisDeSemana = new ArrayList<LocalDate>();
        LocalDate data = dataInicio;
        while (data.isBefore(dataFim) || data.isEqual(dataFim)) {
            if (DateUtils.isFinalDeSemana(data)) {
                diasFinaisDeSemana.add(data);
            }
            data = data.plusDays(1L);
        }
        return diasFinaisDeSemana;
    }
}

