/*
 * Decompiled with CFR 0.152.
 */
package br.gov.cgu.utils;

import java.text.ParseException;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang3.StringUtils;

public final class CpfCnpjUtils {
    public static final int TAMANHO_CNPJ = 14;
    public static final int TAMANHO_CPF = 11;
    private static final String PAD_STRING = "0";
    private static final int FATOR_SOMA_CNPJ = 11;
    private static final int MAIOR_DIGITO = 9;
    private static final int MENOR_DIGITO = 0;
    private static final int TAMANHO_CNPJ_SEM_DIGITOS = 12;
    private static final int TAMANHO_CPF_SEM_DIGITO = 9;
    private static final int[] PESOS_CPF = new int[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final int[] PESOS_CNPJ = new int[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final String MASCARA_CNPJ = "##.###.###/####-##";
    private static final String MASCARA_CPF = "###.###.###-##";
    private static final String REGEX_PONTO_E_BARRA = "(\\.)|(-)|(/)";
    private static final String VAZIO = "";

    private CpfCnpjUtils() {
    }

    public static String formatarPeloTamanho(String cnpjOuCpf) {
        if (cnpjOuCpf == null) {
            return VAZIO;
        }
        String cnpjOuCpfSemEspacos = cnpjOuCpf.trim();
        if (cnpjOuCpfSemEspacos.length() == 14) {
            return CpfCnpjUtils.formatarCnpj(cnpjOuCpfSemEspacos);
        }
        if (cnpjOuCpfSemEspacos.length() == 11) {
            return CpfCnpjUtils.formatarCpf(cnpjOuCpfSemEspacos);
        }
        return cnpjOuCpf;
    }

    public static String formatarPeloTamanhoComSigiloNoCpf(String cnpjOuCpf) {
        if (cnpjOuCpf == null) {
            return VAZIO;
        }
        String cnpjOuCpfSemEspacos = cnpjOuCpf.trim();
        if (cnpjOuCpfSemEspacos.length() == 14) {
            return CpfCnpjUtils.formatarCnpj(cnpjOuCpfSemEspacos);
        }
        if (cnpjOuCpfSemEspacos.length() == 11) {
            return CpfCnpjUtils.formatarCpfComSigilo(cnpjOuCpfSemEspacos);
        }
        return cnpjOuCpf;
    }

    public static String formatarCnpj(String cnpj) {
        String cnpjFormatado;
        try {
            cnpjFormatado = CpfCnpjUtils.formatarStringComMascara(StringUtils.leftPad((String)cnpj, (int)14, (String)PAD_STRING), MASCARA_CNPJ);
        }
        catch (ParseException ex) {
            cnpjFormatado = cnpj;
        }
        return cnpjFormatado;
    }

    public static String formatarCpf(String cpf) {
        String formatado;
        try {
            formatado = CpfCnpjUtils.formatarStringComMascara(StringUtils.leftPad((String)cpf, (int)11, (String)PAD_STRING), MASCARA_CPF);
        }
        catch (ParseException ex) {
            formatado = cpf;
        }
        return formatado;
    }

    public static String formatarCpfComSigilo(String cpf) {
        if (cpf == null) {
            return VAZIO;
        }
        String formatado = CpfCnpjUtils.formatarCpf(cpf);
        if (formatado.length() < 14) {
            return VAZIO;
        }
        return "***" + formatado.substring(3, 7) + formatado.substring(7, 12) + "**";
    }

    private static String formatarStringComMascara(String texto, String mascara) throws ParseException {
        if (texto == null) {
            return null;
        }
        MaskFormatter formatter = new MaskFormatter(mascara);
        formatter.setValueContainsLiteralCharacters(false);
        return formatter.valueToString(texto);
    }

    public static String desformatarCpfCnpj(String cpfCnpj) {
        if (StringUtils.isEmpty((CharSequence)cpfCnpj)) {
            return null;
        }
        return cpfCnpj.replaceAll(REGEX_PONTO_E_BARRA, VAZIO);
    }

    private static int calcularDigito(String str, int[] peso) {
        int soma = 0;
        for (int indice = str.length() - 1; indice >= 0; --indice) {
            int digito = Integer.parseInt(str.substring(indice, indice + 1));
            soma += digito * peso[peso.length - str.length() + indice];
        }
        return (soma = 11 - soma % 11) > 9 ? 0 : soma;
    }

    public static boolean validarCnpj(String cnpj) {
        if (StringUtils.isEmpty((CharSequence)cnpj)) {
            return true;
        }
        if (cnpj.length() != 14) {
            return false;
        }
        Integer digito1 = CpfCnpjUtils.calcularDigito(cnpj.substring(0, 12), PESOS_CNPJ);
        Integer digito2 = CpfCnpjUtils.calcularDigito(cnpj.substring(0, 12) + digito1, PESOS_CNPJ);
        return cnpj.equals(cnpj.substring(0, 12) + digito1.toString() + digito2.toString());
    }

    public static boolean validarCpf(String cpf) {
        if (StringUtils.isEmpty((CharSequence)cpf)) {
            return true;
        }
        if (cpf.length() != 11) {
            return false;
        }
        Integer digito1 = CpfCnpjUtils.calcularDigito(cpf.substring(0, 9), PESOS_CPF);
        Integer digito2 = CpfCnpjUtils.calcularDigito(cpf.substring(0, 9) + digito1, PESOS_CPF);
        return cpf.equals(cpf.substring(0, 9) + digito1.toString() + digito2.toString());
    }
}

