package br.gov.cgu.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

/**
 * Classe utilitária para leitura de tokens JWT
 *
 * @since 5.2.0
 */
public final class JWTUtils {

    private JWTUtils() { /* Não devem existir instâncias desta classe! */ }

    public static Map<String, Object> getMap(String accessToken) {
        try {
            String jwtBase64 = accessToken.split("\\.")[1];
            String jwtJson = new String(Base64.getDecoder().decode(jwtBase64.getBytes()));
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(jwtJson, new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            return Collections.singletonMap("error", String.format("Could not fetch user details: %s %s", ex.getClass(), ex.getMessage()));
        }
    }



}