/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BuildService;
import br.eti.kinoshita.testlinkjavaapi.MiscService;
import br.eti.kinoshita.testlinkjavaapi.ReqSpecService;
import br.eti.kinoshita.testlinkjavaapi.RequirementService;
import br.eti.kinoshita.testlinkjavaapi.TestCaseService;
import br.eti.kinoshita.testlinkjavaapi.TestPlanService;
import br.eti.kinoshita.testlinkjavaapi.TestProjectService;
import br.eti.kinoshita.testlinkjavaapi.TestSuiteService;
import br.eti.kinoshita.testlinkjavaapi.constants.ActionOnDuplicate;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.constants.ResponseDetails;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseDetails;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseStepAction;
import br.eti.kinoshita.testlinkjavaapi.constants.TestImportance;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkAPI {
    private URL url;
    private String devKey;
    private final TestProjectService testProjectService;
    private final TestPlanService testPlanService;
    private final MiscService miscService;
    private final TestCaseService testCaseService;
    private final TestSuiteService testSuiteService;
    private final BuildService buildService;
    private final RequirementService requirementService;
    private final ReqSpecService reqSpecService;
    private static final Logger LOG = LoggerFactory.getLogger(TestLinkAPI.class);
    private XmlRpcClient xmlRpcClient;
    private static final String XMLRPC_BASIC_ENCODING = "xmlrpc.basicEncoding";
    private static final String XMLRPC_BASIC_PASSWORD = "xmlrpc.basicPassword";
    private static final String XMLRPC_BASIC_USERNAME = "xmlrpc.basicUsername";
    private static final String XMLRPC_CONNECTION_TIMEOUT = "xmlrpc.connectionTimeout";
    private static final String XMLRPC_CONTENT_LENGTH_OPTIONAL = "xmlrpc.contentLengthOptional";
    private static final String XMLRPC_ENABLED_FOR_EXCEPTIONS = "xmlrpc.enabledForExceptions";
    private static final String XMLRPC_ENCODING = "xmlrpc.encoding";
    private static final String XMLRPC_GZIP_COMPRESSION = "xmlrpc.gzipCompression";
    private static final String XMLRPC_GZIP_REQUESTING = "xmlrpc.gzipRequesting";
    private static final String XMLRPC_REPLY_TIMEOUT = "xmlrpc.replyTimeout";
    private static final String XMLRPC_USER_AGENT = "xmlrpc.userAgent";

    public TestLinkAPI(URL url, String devKey) throws TestLinkAPIException {
        this.url = url;
        this.devKey = devKey;
        this.xmlRpcClient = new XmlRpcClient();
        CompositeConfiguration appConfig = this.createApplicationConfiguration();
        XmlRpcClientConfigImpl config = this.createXmlRpcClientConfiguration(url, appConfig);
        this.xmlRpcClient.setConfig((XmlRpcClientConfig)config);
        this.testProjectService = new TestProjectService(this.xmlRpcClient, devKey);
        this.testPlanService = new TestPlanService(this.xmlRpcClient, devKey);
        this.miscService = new MiscService(this.xmlRpcClient, devKey);
        this.testCaseService = new TestCaseService(this.xmlRpcClient, devKey);
        this.testSuiteService = new TestSuiteService(this.xmlRpcClient, devKey);
        this.buildService = new BuildService(this.xmlRpcClient, devKey);
        this.requirementService = new RequirementService(this.xmlRpcClient, devKey);
        this.reqSpecService = new ReqSpecService(this.xmlRpcClient, devKey);
        this.miscService.checkDevKey(devKey);
    }

    private CompositeConfiguration createApplicationConfiguration() {
        CompositeConfiguration appConfig = new CompositeConfiguration();
        appConfig.addConfiguration((Configuration)new SystemConfiguration());
        try {
            appConfig.addConfiguration((Configuration)new PropertiesConfiguration("testlinkjavaapi.properties"));
        }
        catch (ConfigurationException ce) {
            this.debug(ce);
        }
        return appConfig;
    }

    private XmlRpcClientConfigImpl createXmlRpcClientConfiguration(URL url, CompositeConfiguration appConfig) {
        XmlRpcClientConfigImpl xmlRpcClientConfig = new XmlRpcClientConfigImpl();
        xmlRpcClientConfig.setServerURL(url);
        xmlRpcClientConfig.setEnabledForExtensions(true);
        xmlRpcClientConfig.setBasicEncoding(appConfig.getString(XMLRPC_BASIC_ENCODING));
        xmlRpcClientConfig.setBasicPassword(appConfig.getString(XMLRPC_BASIC_PASSWORD));
        xmlRpcClientConfig.setBasicUserName(appConfig.getString(XMLRPC_BASIC_USERNAME));
        try {
            xmlRpcClientConfig.setConnectionTimeout(appConfig.getInt(XMLRPC_CONNECTION_TIMEOUT));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        try {
            xmlRpcClientConfig.setContentLengthOptional(appConfig.getBoolean(XMLRPC_CONTENT_LENGTH_OPTIONAL));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        try {
            xmlRpcClientConfig.setEnabledForExceptions(appConfig.getBoolean(XMLRPC_ENABLED_FOR_EXCEPTIONS));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        xmlRpcClientConfig.setEncoding(appConfig.getString(XMLRPC_ENCODING));
        try {
            xmlRpcClientConfig.setGzipCompressing(appConfig.getBoolean(XMLRPC_GZIP_COMPRESSION));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        try {
            xmlRpcClientConfig.setGzipRequesting(appConfig.getBoolean(XMLRPC_GZIP_REQUESTING));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        try {
            xmlRpcClientConfig.setReplyTimeout(appConfig.getInt(XMLRPC_REPLY_TIMEOUT));
        }
        catch (ConversionException ce) {
            this.debug(ce);
        }
        catch (NoSuchElementException nsee) {
            this.debug(nsee);
        }
        xmlRpcClientConfig.setUserAgent(appConfig.getString(XMLRPC_USER_AGENT));
        return xmlRpcClientConfig;
    }

    private void debug(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(throwable.getMessage(), throwable);
        }
    }

    public XmlRpcClient getXmlRpcClient() {
        return this.xmlRpcClient;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDevKey() {
        return this.devKey;
    }

    public String toString() {
        return "TestLinkAPI [url=" + this.url + ", devKey=********]";
    }

    public Boolean checkDevKey(String devKey) throws TestLinkAPIException {
        return this.miscService.checkDevKey(devKey);
    }

    public Boolean doesUserExist(String user) throws TestLinkAPIException {
        return this.miscService.doesUserExist(user);
    }

    public String ping() throws TestLinkAPIException {
        return this.sayHello();
    }

    public String sayHello() throws TestLinkAPIException {
        return this.miscService.sayHello();
    }

    public String about() throws TestLinkAPIException {
        return this.miscService.about();
    }

    public Boolean setTestMode(Boolean testMode) throws TestLinkAPIException {
        return this.miscService.setTestMode(testMode);
    }

    public String repeat(String str) throws TestLinkAPIException {
        return this.miscService.repeat(str);
    }

    public Attachment uploadAttachment(Integer fkId, String fkTable, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.miscService.uploadAttachment(fkId, fkTable, title, description, fileName, fileType, content);
    }

    public String[] getFullPath(Integer nodeId) throws TestLinkAPIException {
        return this.miscService.getFullPath(nodeId);
    }

    public Execution getLastExecutionResult(Integer testPlanId, Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        return this.miscService.getLastExecutionResult(testPlanId, testCaseId, testCaseExternalId);
    }

    public TestProject createTestProject(String testProjectName, String testProjectPrefix, String notes, Boolean enableRequirements, Boolean enableTestPriority, Boolean enableAutomation, Boolean enableInventory, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        return this.testProjectService.createTestProject(testProjectName, testProjectPrefix, notes, enableRequirements, enableTestPriority, enableAutomation, enableInventory, isActive, isPublic);
    }

    public TestProject getTestProjectByName(String projectName) throws TestLinkAPIException {
        return this.testProjectService.getTestProjectByName(projectName);
    }

    public TestProject[] getProjects() throws TestLinkAPIException {
        return this.testProjectService.getProjects();
    }

    public TestPlan[] getProjectTestPlans(Integer projectId) throws TestLinkAPIException {
        return this.testProjectService.getProjectTestPlans(projectId);
    }

    public Attachment uploadTestProjectAttachment(Integer testProjectId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testProjectService.uploadTestProjectAttachment(testProjectId, title, description, fileName, fileType, content);
    }

    public TestPlan createTestPlan(String planName, String projectName, String notes, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        return this.testPlanService.createTestPlan(planName, projectName, notes, isActive, isPublic);
    }

    public TestPlan getTestPlanByName(String planName, String projectName) throws TestLinkAPIException {
        return this.testPlanService.getTestPlanByName(planName, projectName);
    }

    public Platform[] getTestPlanPlatforms(Integer planId) throws TestLinkAPIException {
        return this.testPlanService.getTestPlanPlatforms(planId);
    }

    public Map<String, Object> getTotalsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.testPlanService.getTotalsForTestPlan(testPlanId);
    }

    public Build createBuild(Integer testPlanId, String buildName, String buildNotes) throws TestLinkAPIException {
        return this.buildService.createBuild(testPlanId, buildName, buildNotes);
    }

    public Build[] getBuildsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.buildService.getBuildsForTestPlan(testPlanId);
    }

    public Build getLatestBuildForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.buildService.getLatestBuildForTestPlan(testPlanId);
    }

    public Map<String, Object> getExecCountersByBuild(Integer testPlanId) {
        return this.buildService.getExecCountersByBuild(testPlanId);
    }

    public TestSuite createTestSuite(Integer testProjectId, String name, String details, Integer parentId, Integer order, Boolean checkDuplicatedName, ActionOnDuplicate actionOnDuplicatedName) throws TestLinkAPIException {
        return this.testSuiteService.createTestSuite(testProjectId, name, details, parentId, order, checkDuplicatedName, actionOnDuplicatedName);
    }

    public TestSuite[] getTestSuiteByID(List<Integer> testSuiteIds) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuiteByID(testSuiteIds);
    }

    public Attachment uploadTestSuiteAttachment(Integer testSuiteId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testSuiteService.uploadTestSuiteAttachment(testSuiteId, title, description, fileName, fileType, content);
    }

    public TestSuite[] getTestSuitesForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuitesForTestPlan(testPlanId);
    }

    public TestSuite[] getTestSuitesForTestSuite(Integer testSuiteId) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuitesForTestSuite(testSuiteId);
    }

    public TestSuite[] getFirstLevelTestSuitesForTestProject(Integer testProjectId) throws TestLinkAPIException {
        return this.testSuiteService.getFirstLevelTestSuitesForTestProject(testProjectId);
    }

    public TestCase createTestCase(String testCaseName, Integer testSuiteId, Integer testProjectId, String authorLogin, String summary, List<TestCaseStep> steps, String preconditions, TestImportance importance, ExecutionType execution, Integer order, Integer internalId, Boolean checkDuplicatedName, ActionOnDuplicate actionOnDuplicatedName) throws TestLinkAPIException {
        return this.testCaseService.createTestCase(testCaseName, testSuiteId, testProjectId, authorLogin, summary, steps, preconditions, importance, execution, order, internalId, checkDuplicatedName, actionOnDuplicatedName);
    }

    public Map<String, Object> createTestCaseSteps(Integer testCaseId, String testCaseExternalId, Integer version, TestCaseStepAction action, List<TestCaseStep> testCaseSteps) throws TestLinkAPIException {
        return this.testCaseService.createTestCaseSteps(testCaseId, testCaseExternalId, version, action, testCaseSteps);
    }

    public Map<String, Object> deleteTestCaseSteps(String testCaseExternalId, Integer version, List<TestCaseStep> testCaseSteps) throws TestLinkAPIException {
        return this.testCaseService.deleteTestCaseSteps(testCaseExternalId, version, testCaseSteps);
    }

    public Integer addTestCaseToTestPlan(Integer testProjectId, Integer testPlanId, Integer testCaseId, Integer version, Integer platformId, Integer order, Integer urgency) throws TestLinkAPIException {
        return this.testCaseService.addTestCaseToTestPlan(testProjectId, testPlanId, testCaseId, version, platformId, order, urgency);
    }

    public TestCase[] getTestCasesForTestSuite(Integer testSuiteId, Boolean deep, TestCaseDetails detail) throws TestLinkAPIException {
        return this.testCaseService.getTestCasesForTestSuite(testSuiteId, deep, detail);
    }

    public TestCase getTestCase(Integer testCaseId, Integer testCaseExternalId, Integer version) throws TestLinkAPIException {
        return this.testCaseService.getTestCase(testCaseId, testCaseExternalId, version);
    }

    public TestCase getTestCaseByExternalId(String fullTestCaseExternalId, Integer version) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseByExternalId(fullTestCaseExternalId, version);
    }

    public TestCase[] getTestCasesForTestPlan(Integer testPlanId, List<Integer> testCasesIds, Integer buildId, List<Integer> keywordsIds, String keywords, Boolean executed, List<Integer> assignedTo, String executeStatus, ExecutionType executionType, Boolean getStepInfo, TestCaseDetails detail) throws TestLinkAPIException {
        return this.testCaseService.getTestCasesForTestPlan(testPlanId, testCasesIds, buildId, keywordsIds, keywords, executed, assignedTo, executeStatus, executionType, getStepInfo, detail);
    }

    public Integer getTestCaseIDByName(String testCaseName, String testSuiteName, String testProjectName, String testCasePathName) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseIDByName(testCaseName, testSuiteName, testProjectName, testCasePathName);
    }

    public Attachment uploadTestCaseAttachment(Integer testCaseId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testCaseService.uploadTestCaseAttachment(testCaseId, title, description, fileName, fileType, content);
    }

    public Attachment[] getTestCaseAttachments(Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseAttachments(testCaseId, testCaseExternalId);
    }

    public Attachment uploadExecutionAttachment(Integer executionId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testCaseService.uploadExecutionAttachment(executionId, title, description, fileName, fileType, content);
    }

    public void deleteExecution(Integer executionId) throws TestLinkAPIException {
        this.testCaseService.deleteExecution(executionId);
    }

    public ReportTCResultResponse reportTCResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        return this.testCaseService.reportTCResult(testCaseId, testCaseExternalId, testPlanId, status, buildId, buildName, notes, guess, bugId, platformId, platformName, customFields, overwrite);
    }

    public ReportTCResultResponse setTestCaseExecutionResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        return this.testCaseService.reportTCResult(testCaseId, testCaseExternalId, testPlanId, status, buildId, buildName, notes, guess, bugId, platformId, platformName, customFields, overwrite);
    }

    public CustomField getTestCaseCustomFieldDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseCustomFieldDesignValue(testCaseId, testCaseExternalId, versionNumber, testProjectId, customFieldName, details);
    }

    protected CustomField getTestCaseCustomFieldTestPlanDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseCustomFieldTestPlanDesignValue(testCaseId, testCaseExternalId, versionNumber, testProjectId, customFieldName, details);
    }

    protected CustomField getTestCaseCustomFieldExecutionValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer executionId, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseCustomFieldExecutionValue(testCaseId, testCaseExternalId, versionNumber, executionId, testProjectId, customFieldName, details);
    }

    public Map<String, Object> setTestCaseExecutionType(Integer testProjectId, Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, ExecutionType executionType) {
        return this.testCaseService.setTestCaseExecutionType(testProjectId, testCaseId, testCaseExternalId, versionNumber, executionType);
    }

    public Attachment uploadRequirementSpecificationAttachment(Integer reqSpecId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.reqSpecService.uploadRequirementSpecificationAttachment(reqSpecId, title, description, fileName, fileType, content);
    }

    public Attachment uploadRequirementAttachment(Integer requirementId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.requirementService.uploadRequirementAttachment(requirementId, title, description, fileName, fileType, content);
    }

    public void assignRequirements(Integer testCaseId, Integer testProjectId, List<Requirement> requirements) throws TestLinkAPIException {
        this.requirementService.assignRequirements(testCaseId, testProjectId, requirements);
    }

    public Object executeXmlRpcCall(String methodName, Map<String, Object> executionData) throws XmlRpcException, TestLinkAPIException {
        return this.miscService.executeXmlRpcCall(methodName, executionData);
    }
}

