/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestPlanService
extends BaseService {
    protected TestPlanService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestPlan createTestPlan(String planName, String projectName, String notes, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        TestPlan testPlan = null;
        Integer id = 0;
        testPlan = new TestPlan(id, planName, projectName, notes, isActive, isPublic);
        try {
            Map<String, Object> executionData = Util.getTestPlanMap(testPlan);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_TEST_PLAN.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            testPlan.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testPlan;
    }

    protected TestPlan getTestPlanByName(String planName, String projectName) throws TestLinkAPIException {
        TestPlan testPlan = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_NAME.toString(), planName);
            executionData.put(TestLinkParams.TEST_PROJECT_NAME.toString(), projectName);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_PLAN_BY_NAME.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            responseMap.put(TestLinkResponseParams.PROJECT_NAME.toString(), projectName);
            testPlan = Util.getTestPlan(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testPlan;
    }

    protected Platform[] getTestPlanPlatforms(Integer planId) throws TestLinkAPIException {
        Platform[] platforms = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), planId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_PLAN_PLATFORMS.toString(), executionData);
            Object[] responseArray = (Object[])response;
            platforms = new Platform[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Platform platform;
                Map projectMap = (Map)responseArray[i];
                platforms[i] = platform = Util.getPlatform(projectMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving platforms: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return platforms;
    }

    protected Map<String, Object> getTotalsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        Map responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TOTALS_FOR_TEST_PLAN.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] responseArray = (Object[])response;
                responseMap = (Map)responseArray[0];
            } else if (response instanceof Map) {
                responseMap = (Map)response;
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving platforms: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }
}

