/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.xmlrpc.XmlRpcException;

public class CustomLoggingUtils {
    public static void logRequest(Logger logger, RequestEntity requestEntity) throws XmlRpcException {
        ByteArrayOutputStream bos = null;
        try {
            logger.log(Level.FINE, "---- Request ----");
            bos = new ByteArrayOutputStream();
            requestEntity.writeRequest((OutputStream)bos);
            logger.log(Level.FINE, CustomLoggingUtils.toPrettyXml(logger, bos.toString()));
        }
        catch (IOException e) {
            try {
                throw new XmlRpcException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
    }

    public static void logRequest(Logger logger, String content) {
        logger.log(Level.FINE, "---- Request ----");
        logger.log(Level.FINE, CustomLoggingUtils.toPrettyXml(logger, content));
    }

    public static String logResponse(Logger logger, InputStream istream) throws XmlRpcException {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(istream));
            String line = null;
            StringBuilder respBuf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                respBuf.append(line);
            }
            String response = respBuf.toString();
            logger.log(Level.FINE, "---- Response ----");
            logger.log(Level.FINE, CustomLoggingUtils.toPrettyXml(logger, respBuf.toString()));
            string = response;
        }
        catch (IOException e) {
            try {
                throw new XmlRpcException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    public static void logResponse(Logger logger, String content) {
        logger.log(Level.FINE, "---- Response ----");
        logger.log(Level.FINE, CustomLoggingUtils.toPrettyXml(logger, content));
    }

    private static String toPrettyXml(Logger logger, String xml) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            StreamSource source = new StreamSource(new StringReader(xml));
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't parse XML");
            return xml;
        }
    }
}

