/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestSuiteService
extends BaseService {
    public TestSuiteService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestSuite createTestSuite(Integer testProjectId, String name, String details, Integer parentId, Integer order, Boolean checkDuplicatedName, String actionOnDuplicatedName) throws TestLinkAPIException {
        TestSuite testSuite = null;
        Integer id = 0;
        testSuite = new TestSuite(id, testProjectId, name, details, parentId, order, checkDuplicatedName, actionOnDuplicatedName);
        try {
            Map<String, Object> executionData = Util.getTestSuiteMap(testSuite);
            Object response = this.executeXmlRpcCall(TestLinkMethods.createTestSuite.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            testSuite.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuite;
    }

    protected TestSuite[] getTestSuiteByID(List<Integer> testSuiteIds) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testSuiteId.toString(), testSuiteIds);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestSuiteByID.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] responseArray = (Object[])response;
                testSuites = new TestSuite[responseArray.length];
                for (int i = 0; i < responseArray.length; ++i) {
                    Map responseMap = (Map)responseArray[i];
                    testSuites[i] = Util.getTestSuite(responseMap);
                }
            } else if (response instanceof Map) {
                testSuites = new TestSuite[1];
                Map responseMap = (Map)response;
                testSuites[0] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites by id: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected Attachment uploadTestSuiteAttachment(Integer testSuiteId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, testSuiteId, TestLinkTables.nodesHierarchy.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestSuiteAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.uploadTestSuiteAttachment.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected TestSuite[] getTestSuitesForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testPlanId.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestSuitesForTestPlan.toString(), executionData);
            Object[] responseArray = (Object[])response;
            testSuites = new TestSuite[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testSuites[i] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites by Test Plan ID: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected TestSuite[] getTestSuitesForTestSuite(Integer testSuiteId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testSuiteId.toString(), testSuiteId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestSuitesForTestSuite.toString(), executionData);
            Map responseMap = (Map)response;
            Set entrySet = responseMap.entrySet();
            testSuites = new TestSuite[entrySet.size()];
            boolean singleElement = false;
            int index = 0;
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object o = entry.getValue();
                if (o instanceof String) {
                    singleElement = true;
                    break;
                }
                Map testSuiteMap = (Map)entry.getValue();
                testSuiteMap.put(TestLinkResponseParams.id.toString(), key);
                testSuites[index] = Util.getTestSuite(testSuiteMap);
                ++index;
            }
            if (singleElement) {
                testSuites = new TestSuite[]{Util.getTestSuite(responseMap)};
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites which are DIRECT children of a given TestSuite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected TestSuite[] getFirstLevelTestSuitesForTestProject(Integer testProjectId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testProjectId.toString(), testProjectId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getFirstLevelTestSuitesForTestProject.toString(), executionData);
            Object[] responseArray = (Object[])response;
            testSuites = new TestSuite[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testSuites[i] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites AT TOP LEVEL of tree on a Test Project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }
}

