/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.model.ResponseDetails;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestImportance;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestCaseService
extends BaseService {
    public TestCaseService(String url, String devKey) throws MalformedURLException {
        super(url, devKey);
    }

    protected TestCase createTestCase(String testCaseName, Integer testSuiteId, Integer testProjectId, String authorLogin, String summary, List<TestCaseStep> steps, String preconditions, TestImportance importance, ExecutionType execution, Integer order, Integer internalId, Boolean checkDuplicatedName, String actionOnDuplicatedName) throws TestLinkAPIException {
        TestCase testCase = null;
        Integer id = null;
        testCase = new TestCase(id, testCaseName, testSuiteId, testProjectId, authorLogin, summary, steps, preconditions, importance, execution, order, internalId, checkDuplicatedName, actionOnDuplicatedName, null, null, null, null, null);
        try {
            Map<String, Object> executionData = Util.getTestCaseMap(testCase);
            Object response = this.executeXmlRpcCall(TestLinkMethods.createTestCase.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            testCase.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCase;
    }

    protected Integer addTestCaseToTestPlan(Integer testProjectId, Integer testPlanId, Integer testCaseId, Integer version, Integer platformId, Integer order, Integer urgency) throws TestLinkAPIException {
        Integer featureId = 0;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testProjectId.toString(), testProjectId);
            executionData.put(TestLinkParams.testPlanId.toString(), testPlanId);
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.version.toString(), version);
            executionData.put(TestLinkParams.platformId.toString(), platformId);
            executionData.put(TestLinkParams.order.toString(), order);
            executionData.put(TestLinkParams.urgency.toString(), testCaseId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.addTestCaseToTestPlan.toString(), executionData);
            Map responseMap = (Map)response;
            featureId = Util.getInteger(responseMap, TestLinkResponseParams.featureId.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error adding test case to test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return featureId;
    }

    protected TestCase[] getTestCasesForTestSuite(Integer testSuiteId, Boolean deep, String details) throws TestLinkAPIException {
        TestCase[] testCases = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testSuiteId.toString(), testSuiteId);
            executionData.put(TestLinkParams.deep.toString(), deep);
            executionData.put(TestLinkParams.details.toString(), details);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestCasesForTestSuite.toString(), executionData);
            Object[] responseArray = (Object[])response;
            testCases = new TestCase[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testCases[i] = Util.getTestCase(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test cases for test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCases;
    }

    protected TestCase[] getTestCasesForTestPlan(Integer testPlanId, List<Integer> testCasesIds, Integer buildId, List<Integer> keywordsIds, String keywords, Boolean executed, List<Integer> assignedTo, String executeStatus, ExecutionType executionType, Boolean getStepInfo) throws TestLinkAPIException {
        TestCase[] testCases = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testPlanId.toString(), testPlanId);
            executionData.put(TestLinkParams.testCaseId.toString(), testCasesIds);
            executionData.put(TestLinkParams.buildId.toString(), buildId);
            executionData.put(TestLinkParams.keywordId.toString(), keywordsIds);
            executionData.put(TestLinkParams.keywords.toString(), keywords);
            executionData.put(TestLinkParams.executed.toString(), executed);
            executionData.put(TestLinkParams.assignedTo.toString(), assignedTo);
            executionData.put(TestLinkParams.executeStatus.toString(), executeStatus);
            executionData.put(TestLinkParams.executionType.toString(), (Object)executionType);
            executionData.put(TestLinkParams.getStepInfo.toString(), getStepInfo);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestCasesForTestPlan.toString(), executionData);
            Map responseMap = (Map)response;
            Set entrySet = responseMap.entrySet();
            testCases = new TestCase[entrySet.size()];
            int index = 0;
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Map testCaseMap = (Map)entry.getValue();
                testCaseMap.put(TestLinkResponseParams.id.toString(), key);
                testCases[index] = Util.getTestCase(testCaseMap);
                ++index;
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test cases for test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCases;
    }

    protected TestCase getTestCase(Integer testCaseId, Integer testCaseExternalId, Integer version) throws TestLinkAPIException {
        TestCase testCase = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testCaseExternalId.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.version.toString(), version);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestCase.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            testCase = Util.getTestCase(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case info : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCase;
    }

    protected Integer getTestCaseIDByName(String testCaseName, String testSuiteName, String testProjectName, String testCasePathName) throws TestLinkAPIException {
        Integer testCaseID = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseName.toString(), testCaseName);
            executionData.put(TestLinkParams.testSuiteName.toString(), testSuiteName);
            executionData.put(TestLinkParams.testProjectName.toString(), testProjectName);
            executionData.put(TestLinkParams.testCasePathName.toString(), testCasePathName);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestCaseIDByName.toString(), executionData);
            Object[] responseArray = (Object[])response;
            Map responseMap = (Map)responseArray[0];
            testCaseID = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case ID : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCaseID;
    }

    protected Attachment uploadTestCaseAttachment(Integer testCaseId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, testCaseId, TestLinkTables.nodesHierarchy.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestCaseAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.uploadTestCaseAttachment.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected Attachment[] getTestCaseAttachments(Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        Attachment[] attachments = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testCaseExternalId.toString(), testCaseExternalId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestCaseAttachments.toString(), executionData);
            if (response instanceof Map) {
                Map responseMap = (Map)response;
                Set entrySet = responseMap.entrySet();
                attachments = new Attachment[entrySet.size()];
                int index = 0;
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    Map attachmentMap = (Map)entry.getValue();
                    attachmentMap.put(TestLinkResponseParams.id.toString(), key);
                    attachments[index] = Util.getAttachment(attachmentMap);
                    ++index;
                }
            } else {
                attachments = new Attachment[]{};
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case's attachments: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachments;
    }

    protected void deleteExecution(Integer executionId) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.executionId.toString(), executionId);
            this.executeXmlRpcCall(TestLinkMethods.deleteExecution.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error deleting execution: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }

    protected void reportTCResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testCaseExternalId.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.testPlanId.toString(), testPlanId);
            executionData.put(TestLinkParams.status.toString(), status.toString());
            executionData.put(TestLinkParams.buildId.toString(), buildId);
            executionData.put(TestLinkParams.buildName.toString(), buildName);
            executionData.put(TestLinkParams.notes.toString(), notes);
            executionData.put(TestLinkParams.guess.toString(), guess);
            executionData.put(TestLinkParams.bugId.toString(), bugId);
            executionData.put(TestLinkParams.platformId.toString(), platformId);
            executionData.put(TestLinkParams.platformName.toString(), platformName);
            executionData.put(TestLinkParams.customFields.toString(), customFields);
            executionData.put(TestLinkParams.overwrite.toString(), overwrite);
            this.executeXmlRpcCall(TestLinkMethods.reportTCResult.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error reporting TC result: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }

    protected CustomField getTestCaseCustomFieldDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        CustomField customField = null;
        try {
            Object response;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testCaseExternalId.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.version.toString(), versionNumber);
            executionData.put(TestLinkParams.testProjectId.toString(), testProjectId);
            executionData.put(TestLinkParams.customFieldName.toString(), customFieldName);
            if (details != null) {
                executionData.put(TestLinkParams.details.toString(), details.toString());
            }
            if ((response = this.executeXmlRpcCall(TestLinkMethods.getTestCaseCustomFieldDesignValue.toString(), executionData)) instanceof String) {
                customField = new CustomField();
                customField.setValue(response.toString());
            } else if (response instanceof Map) {
                Map responseMap = (Map)response;
                customField = Util.getCustomField(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case custom field value: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return customField;
    }
}

