/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.parser;

import br.eti.kinoshita.tap4j.model.BailOut;
import br.eti.kinoshita.tap4j.model.Comment;
import br.eti.kinoshita.tap4j.model.Directive;
import br.eti.kinoshita.tap4j.model.Footer;
import br.eti.kinoshita.tap4j.model.Header;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.SkipPlan;
import br.eti.kinoshita.tap4j.model.TapResult;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.model.TestSet;
import br.eti.kinoshita.tap4j.model.Text;
import br.eti.kinoshita.tap4j.parser.Parser;
import br.eti.kinoshita.tap4j.parser.ParserException;
import br.eti.kinoshita.tap4j.util.DirectiveValues;
import br.eti.kinoshita.tap4j.util.StatusValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class Tap13Parser
implements Parser {
    protected boolean isFirstLine = true;
    protected boolean isHeaderSet = false;
    protected boolean isPlanSet = false;
    protected boolean planBeforeTestResult = false;
    protected String lastLine = null;
    protected TestSet testSet;
    protected Header header;
    protected Plan plan;
    protected List<TapResult> tapLines = new ArrayList<TapResult>();
    protected List<TestResult> testResults = new ArrayList<TestResult>();
    protected List<BailOut> bailOuts = new ArrayList<BailOut>();
    protected List<Comment> comments = new ArrayList<Comment>();
    protected Footer footer;

    public Tap13Parser() {
        this.init();
    }

    public void init() {
        this.isFirstLine = true;
        this.isHeaderSet = false;
        this.isPlanSet = false;
        this.planBeforeTestResult = false;
        this.lastLine = null;
        this.testSet = null;
        this.header = null;
        this.plan = null;
        this.tapLines = new ArrayList<TapResult>();
        this.testResults = new ArrayList<TestResult>();
        this.bailOuts = new ArrayList<BailOut>();
        this.comments = new ArrayList<Comment>();
    }

    public TestSet getTestSet() {
        this.testSet = new TestSet();
        this.testSet.setHeader(this.header);
        this.testSet.setPlan(this.plan);
        for (TestResult testResult : this.testResults) {
            this.testSet.addTestResult(testResult);
        }
        for (BailOut bailOut : this.bailOuts) {
            this.testSet.addBailOut(bailOut);
        }
        for (Comment comment : this.comments) {
            this.testSet.addComment(comment);
        }
        this.testSet.setFooter(this.footer);
        return this.testSet;
    }

    public void parseLine(String tapLine) throws ParserException {
        if (StringUtils.isEmpty((String)tapLine)) {
            return;
        }
        Matcher matcher = null;
        matcher = COMMENT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractComment(matcher);
            return;
        }
        this.lastLine = tapLine;
        matcher = HEADER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPHeaderParsingLocationAndDuplicity();
            this.extractHeader(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = PLAN_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPPlanDuplicity();
            this.checkIfTAPPlanIsSetBeforeTestResultsOrBailOut();
            this.extractPlan(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = TEST_RESULT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractTestResult(matcher);
            return;
        }
        matcher = BAIL_OUT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractBailOut(matcher);
            return;
        }
        matcher = FOOTER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractFooter(matcher);
            return;
        }
        Text text = new Text(tapLine);
        this.tapLines.add(text);
    }

    protected void checkIfTAPPlanIsSetBeforeTestResultsOrBailOut() {
        if (this.testResults.size() <= 0 && this.bailOuts.size() <= 0) {
            this.planBeforeTestResult = true;
        }
    }

    protected void checkTAPHeaderParsingLocationAndDuplicity() throws ParserException {
        if (this.isHeaderSet) {
            throw new ParserException("Duplicated TAP Header found.");
        }
        if (!this.isFirstLine) {
            throw new ParserException("Invalid position of TAP Header. It must be the first element (apart of Comments) in the TAP Stream.");
        }
        this.isHeaderSet = true;
    }

    protected void checkTAPPlanDuplicity() throws ParserException {
        if (this.isPlanSet) {
            throw new ParserException("Duplicated TAP Plan found.");
        }
        this.isPlanSet = true;
    }

    protected void checkTAPPlanPosition() throws ParserException {
        if (!this.planBeforeTestResult) {
            Matcher matcher = PLAN_PATTERN.matcher(this.lastLine);
            if (matcher.matches()) {
                return;
            }
            throw new ParserException("Invalid position of TAP Plan.");
        }
    }

    protected void extractHeader(Matcher matcher) {
        Integer version = Integer.parseInt(matcher.group(1));
        Header header = new Header(version);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            header.setComment(comment);
        }
        this.header = header;
    }

    protected void extractPlan(Matcher matcher) {
        String commentToken;
        Integer initialTest = Integer.parseInt(matcher.group(1));
        Integer lastTest = Integer.parseInt(matcher.group(3));
        Plan plan = null;
        plan = new Plan(initialTest, lastTest);
        String skipToken = matcher.group(4);
        if (skipToken != null) {
            String reason = matcher.group(5);
            SkipPlan skip = new SkipPlan(reason);
            plan.setSkip(skip);
        }
        if ((commentToken = matcher.group(6)) != null) {
            String text = matcher.group(7);
            Comment comment = new Comment(text);
            plan.setComment(comment);
        }
        this.plan = plan;
    }

    protected void extractTestResult(Matcher matcher) {
        String commentToken;
        TestResult testResult = null;
        String okOrNotOk = matcher.group(1);
        StatusValues status = null;
        status = okOrNotOk.trim().equals("ok") ? StatusValues.OK : StatusValues.NOT_OK;
        Integer testNumber = this.getTestNumber(matcher.group(2));
        testResult = new TestResult(status, testNumber);
        testResult.setDescription(matcher.group(3));
        String directiveToken = matcher.group(4);
        if (directiveToken != null) {
            String directiveText = matcher.group(5);
            DirectiveValues directiveValue = null;
            directiveValue = directiveText.trim().equals("TODO") ? DirectiveValues.TODO : DirectiveValues.SKIP;
            String reason = matcher.group(6);
            Directive directive = new Directive(directiveValue, reason);
            testResult.setDirective(directive);
        }
        if ((commentToken = matcher.group(7)) != null) {
            String text = matcher.group(8);
            Comment comment = new Comment(text);
            testResult.setComment(comment);
        }
        this.testResults.add(testResult);
        this.tapLines.add(testResult);
    }

    private Integer getTestNumber(String testNumber) {
        Integer integerTestNumber = null;
        integerTestNumber = StringUtils.isEmpty((String)testNumber) ? Integer.valueOf(this.testResults.size() + 1) : Integer.valueOf(Integer.parseInt(testNumber));
        return integerTestNumber;
    }

    protected void extractBailOut(Matcher matcher) {
        String reason = matcher.group(1);
        BailOut bailOut = new BailOut(reason);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            bailOut.setComment(comment);
        }
        this.bailOuts.add(bailOut);
        this.tapLines.add(bailOut);
    }

    protected void extractComment(Matcher matcher) {
        String text = matcher.group(1);
        Comment comment = new Comment(text);
        this.comments.add(comment);
        this.tapLines.add(comment);
    }

    protected void extractFooter(Matcher matcher) {
        String text = matcher.group(1);
        Footer footer = new Footer(text);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String commentText = matcher.group(3);
            Comment comment = new Comment(commentText);
            footer.setComment(comment);
        }
        this.footer = footer;
    }

    public TestSet parseTapStream(String tapStream) throws ParserException {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapStream);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotEmpty((String)line)) continue;
                this.parseLine(line);
            }
            this.checkTAPPlanPosition();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    public TestSet parseFile(File tapFile) throws ParserException {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapFile);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotBlank((String)line)) continue;
                this.parseLine(line);
            }
            this.postProcess();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    protected void postProcess() throws ParserException {
        this.checkTAPPlanPosition();
    }
}

