/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.ext.testng;

import br.eti.kinoshita.tap4j.ext.testng.TestNGTAPUtils;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.model.TestSet;
import br.eti.kinoshita.tap4j.producer.TapProducer;
import br.eti.kinoshita.tap4j.producer.TapProducerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.ResultMap;

public class TestTAPReporter
extends TestListenerAdapter {
    protected final ResultMap resultMap = new ResultMap();
    protected final Map<Class<?>, List<ITestResult>> testResultsPerClass = new LinkedHashMap();
    protected final Map<ITestNGMethod, List<ITestResult>> testResultsPerMethod = new LinkedHashMap<ITestNGMethod, List<ITestResult>>();
    protected ITestContext ctx;
    protected TapProducer tapProducer = TapProducerFactory.makeTap13YamlProducer();

    public void onStart(ITestContext testContext) {
        this.ctx = testContext;
    }

    public void onTestSuccess(ITestResult tr) {
        TestNGTAPUtils.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestFailure(ITestResult tr) {
        TestNGTAPUtils.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestSkipped(ITestResult tr) {
        TestNGTAPUtils.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        TestNGTAPUtils.fillAttributes(tr, this.ctx);
        this.resultMap.addResult(tr, tr.getMethod());
    }

    public void onFinish(ITestContext testContext) {
        this.generateTAPPerClass(testContext);
        this.generateTAPPerMethod(testContext);
    }

    protected void generateTAPPerClass(ITestContext testContext) {
        List<ITestResult> testNGTestResults = TestNGTAPUtils.getTestNGResultsOrderedByExecutionDate(this.resultMap);
        for (ITestResult testResult : testNGTestResults) {
            Class<?> clazz = testResult.getMethod().getRealClass();
            List<ITestResult> testResultsForThisClass = this.testResultsPerClass.get(clazz);
            if (testResultsForThisClass == null) {
                testResultsForThisClass = new ArrayList<ITestResult>();
                this.testResultsPerClass.put(clazz, testResultsForThisClass);
            }
            testResultsForThisClass.add(testResult);
        }
        Set<Class<?>> keySet = this.testResultsPerClass.keySet();
        for (Class<?> clazz : keySet) {
            TestSet testSet = new TestSet();
            List<ITestResult> testResults = this.testResultsPerClass.get(clazz);
            testSet.setPlan(new Plan(testResults.size()));
            for (ITestResult testResult : testResults) {
                TestResult tapTestResult = TestNGTAPUtils.generateTAPTestResult(testResult, testSet.getNumberOfTestResults() + 1);
                testSet.addTestResult(tapTestResult);
            }
            File output = new File(testContext.getOutputDirectory(), clazz.getName() + ".tap");
            this.tapProducer.dump(testSet, output);
        }
    }

    protected void generateTAPPerMethod(ITestContext testContext) {
        List<ITestResult> testNGTestResults = TestNGTAPUtils.getTestNGResultsOrderedByExecutionDate(this.resultMap);
        for (ITestResult testResult : testNGTestResults) {
            ITestNGMethod method = testResult.getMethod();
            List<ITestResult> testResultsForThisMethod = this.testResultsPerMethod.get(method);
            if (testResultsForThisMethod == null) {
                testResultsForThisMethod = new ArrayList<ITestResult>();
                this.testResultsPerMethod.put(method, testResultsForThisMethod);
            }
            testResultsForThisMethod.add(testResult);
        }
        Set<ITestNGMethod> keySet = this.testResultsPerMethod.keySet();
        for (ITestNGMethod method : keySet) {
            TestSet testSet = new TestSet();
            List<ITestResult> testResults = this.testResultsPerMethod.get(method);
            testSet.setPlan(new Plan(testResults.size()));
            for (ITestResult testResult : testResults) {
                TestResult tapTestResult = TestNGTAPUtils.generateTAPTestResult(testResult, testSet.getNumberOfTestResults() + 1);
                testSet.addTestResult(tapTestResult);
            }
            File output = new File(testContext.getOutputDirectory(), method.getTestClass().getName() + "#" + method.getMethodName() + ".tap");
            this.tapProducer.dump(testSet, output);
        }
    }
}

