/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.ext.testng;

import br.eti.kinoshita.tap4j.ext.testng.ExecutionDateCompator;
import br.eti.kinoshita.tap4j.ext.testng.TAPAttribute;
import br.eti.kinoshita.tap4j.ext.testng.TestNGYAMLishUtils;
import br.eti.kinoshita.tap4j.model.Directive;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.util.DirectiveValues;
import br.eti.kinoshita.tap4j.util.StatusValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IResultMap;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ResultMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestNGTAPUtils {
    public static final Comparator<ITestResult> EXECUTION_DATE_COMPARATOR = new ExecutionDateCompator();

    private TestNGTAPUtils() {
    }

    public static TestResult generateTAPTestResult(ITestResult testResult, Integer number) {
        TestResult tapTestResult = new TestResult();
        String testResultDescription = TestNGTAPUtils.generateTAPTestResultDescription(testResult);
        tapTestResult.setDescription(testResultDescription);
        TestNGTAPUtils.setTapTestResultStatus(tapTestResult, testResult.getStatus());
        TestNGTAPUtils.createTestNGYAMLishData(tapTestResult, testResult);
        return tapTestResult;
    }

    public static String generateTAPTestResultDescription(ITestResult testResult) {
        StringBuilder description = new StringBuilder();
        description.append("- ");
        description.append(testResult.getTestClass().getName());
        description.append('#');
        description.append(testResult.getMethod().getMethodName());
        return description.toString();
    }

    public static void setTapTestResultStatus(TestResult tapTestResult, int status) {
        switch (status) {
            case 1: {
                tapTestResult.setStatus(StatusValues.OK);
                break;
            }
            case 3: {
                tapTestResult.setStatus(StatusValues.NOT_OK);
                Directive skip = new Directive(DirectiveValues.SKIP, "TestNG test was skipped");
                tapTestResult.setDirective(skip);
                break;
            }
            default: {
                tapTestResult.setStatus(StatusValues.NOT_OK);
            }
        }
    }

    public static void createTestNGYAMLishData(TestResult testResult, ITestResult testNgTestResult) {
        Map<String, Object> yamlish = testResult.getDiagnostic();
        TestNGTAPUtils.createYAMLishMessage(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishSeverity(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishSource(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishDatetime(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishFile(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishLine(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishName(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishExtensions(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishActualAndExpected(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishDisplay(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishDump(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishError(yamlish, testNgTestResult);
        TestNGTAPUtils.createYAMLishBacktrace(yamlish, testNgTestResult);
    }

    public static void createYAMLishMessage(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String message = TestNGYAMLishUtils.getMessage(testNgTestResult);
        yamlish.put("message", message);
    }

    public static void createYAMLishSeverity(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String severity = TestNGYAMLishUtils.getSeverity(testNgTestResult);
        yamlish.put("severity", severity);
    }

    public static void createYAMLishSource(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String source = TestNGYAMLishUtils.getSource(testNgTestResult);
        yamlish.put("source", source);
    }

    public static void createYAMLishDatetime(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String datetime = TestNGYAMLishUtils.getDatetime(testNgTestResult);
        yamlish.put("datetime", datetime);
    }

    public static void createYAMLishFile(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String file = TestNGYAMLishUtils.getFile(testNgTestResult);
        yamlish.put("file", file);
    }

    public static void createYAMLishLine(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String line = TestNGYAMLishUtils.getLine(testNgTestResult);
        yamlish.put("line", line);
    }

    public static void createYAMLishName(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String name = TestNGYAMLishUtils.getName(testNgTestResult);
        yamlish.put("name", name);
    }

    public static void createYAMLishExtensions(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        Object extensions = TestNGYAMLishUtils.getExtensions(testNgTestResult);
        yamlish.put("extensions", extensions);
    }

    public static void createYAMLishActualAndExpected(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String expected = TestNGYAMLishUtils.getExpected(testNgTestResult);
        String actual = TestNGYAMLishUtils.getActual(testNgTestResult);
        if (expected == null) {
            expected = "~";
        }
        if (actual == null) {
            actual = "~";
        }
        yamlish.put("got", actual);
        yamlish.put("expected", expected);
    }

    public static void createYAMLishDisplay(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String display = TestNGYAMLishUtils.getDisplay(testNgTestResult);
        yamlish.put("display", display);
    }

    public static void createYAMLishDump(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        Object dump = TestNGYAMLishUtils.getDump(testNgTestResult);
        yamlish.put("dump", dump);
    }

    public static void createYAMLishError(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String error = TestNGYAMLishUtils.getError(testNgTestResult);
        yamlish.put("error", error);
    }

    public static void createYAMLishBacktrace(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String backtrace = TestNGYAMLishUtils.getBacktrace(testNgTestResult);
        yamlish.put("backtrace", backtrace);
    }

    public static List<ITestResult> getTestNGResultsOrderedByExecutionDate(ITestContext testContext) {
        LinkedHashMap<String, IResultMap> results = new LinkedHashMap<String, IResultMap>();
        results.put("passed", testContext.getPassedTests());
        results.put("failed", testContext.getFailedTests());
        results.put("failedBut", testContext.getFailedButWithinSuccessPercentageTests());
        results.put("skipped", testContext.getSkippedTests());
        ResultMap total = new ResultMap();
        TestNGTAPUtils.addAll(total, (IResultMap)results.get("passed"));
        TestNGTAPUtils.addAll(total, (IResultMap)results.get("failed"));
        TestNGTAPUtils.addAll(total, (IResultMap)results.get("failedBut"));
        TestNGTAPUtils.addAll(total, (IResultMap)results.get("skipped"));
        ITestNGMethod[] allMethodsInCtx = testContext.getAllTestMethods();
        for (int i = 0; i < allMethodsInCtx.length; ++i) {
            ITestNGMethod methodInCtx = allMethodsInCtx[i];
            Collection allMethodsFound = total.getAllMethods();
            boolean exists = false;
            for (ITestNGMethod methodFound : allMethodsFound) {
                if (!methodInCtx.getTestClass().getName().equals(methodFound.getTestClass().getName()) || !methodInCtx.getMethod().getName().equals(methodFound.getMethod().getName())) continue;
                exists = true;
            }
            if (exists) continue;
            org.testng.internal.TestResult skippedTestResult = new org.testng.internal.TestResult((IClass)methodInCtx.getTestClass(), (Object)methodInCtx.getInstances(), methodInCtx, null, testContext.getStartDate().getTime(), testContext.getEndDate().getTime());
            skippedTestResult.setStatus(3);
            total.addResult((ITestResult)skippedTestResult, methodInCtx);
        }
        ArrayList<ITestResult> testNGTestResults = new ArrayList<ITestResult>(total.getAllResults());
        Collections.sort(testNGTestResults, EXECUTION_DATE_COMPARATOR);
        return testNGTestResults;
    }

    public static List<ITestResult> getTestNGResultsOrderedByExecutionDate(ResultMap total) {
        ArrayList<ITestResult> testNGTestResults = new ArrayList<ITestResult>(total.getAllResults());
        Collections.sort(testNGTestResults, EXECUTION_DATE_COMPARATOR);
        return testNGTestResults;
    }

    public static void addAll(ResultMap total, IResultMap map) {
        for (ITestResult testResult : map.getAllResults()) {
            total.addResult(testResult, testResult.getMethod());
        }
    }

    public static void fillAttributes(ITestResult tr, ITestContext ctx) {
        Set attrsNames = ctx.getAttributeNames();
        for (String attr : attrsNames) {
            Object o = ctx.getAttribute(attr);
            if (!(o instanceof TAPAttribute)) continue;
            TAPAttribute tapAttr = (TAPAttribute)o;
            ITestNGMethod testNGMethod = tr.getMethod();
            Method method = testNGMethod.getMethod();
            if (method != tapAttr.getMethod()) continue;
            tr.setAttribute(attr, tapAttr.getValue());
        }
    }
}

