/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.consumer;

import br.eti.kinoshita.tap4j.consumer.TapConsumer;
import br.eti.kinoshita.tap4j.consumer.TapConsumerException;
import br.eti.kinoshita.tap4j.model.TestSet;
import br.eti.kinoshita.tap4j.parser.Parser;
import br.eti.kinoshita.tap4j.parser.ParserException;
import br.eti.kinoshita.tap4j.parser.Tap13Parser;
import java.io.File;

public class TapConsumerImpl
implements TapConsumer {
    protected final Parser parser;
    protected TestSet testSet;

    public TapConsumerImpl() {
        this.parser = new Tap13Parser();
        this.testSet = new TestSet();
    }

    public TapConsumerImpl(Parser parser) {
        this.parser = parser;
    }

    public TestSet getTestSet() {
        return this.testSet;
    }

    public TestSet load(File file) throws TapConsumerException {
        try {
            this.testSet = this.parser.parseFile(file);
        }
        catch (ParserException e) {
            throw new TapConsumerException("Failed to parse file " + file + ": " + e.getMessage(), e);
        }
        return this.testSet;
    }

    public TestSet load(String tapStream) throws TapConsumerException {
        try {
            this.testSet = this.parser.parseTapStream(tapStream);
        }
        catch (ParserException e) {
            throw new TapConsumerException("Failed to parse TAP Stream " + tapStream + ": " + e.getMessage(), e);
        }
        return this.testSet;
    }

    public Parser getParser() {
        return this.parser;
    }
}

