/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.model;

import br.eti.kinoshita.tap4j.model.BailOut;
import br.eti.kinoshita.tap4j.model.Comment;
import br.eti.kinoshita.tap4j.model.Footer;
import br.eti.kinoshita.tap4j.model.Header;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.TapResult;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.util.StatusValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Header header;
    private Plan plan;
    private List<TapResult> tapLines = new ArrayList<TapResult>();
    private List<TestResult> testResults = new ArrayList<TestResult>();
    private List<BailOut> bailOuts = new ArrayList<BailOut>();
    private List<Comment> comments = new ArrayList<Comment>();
    private Footer footer;

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public List<TapResult> getTapLines() {
        return this.tapLines;
    }

    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public List<BailOut> getBailOuts() {
        return this.bailOuts;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public boolean addTapLine(TapResult tapLine) {
        return this.tapLines.add(tapLine);
    }

    public boolean addTestResult(TestResult testResult) {
        if (testResult.getTestNumber() == null || testResult.getTestNumber() <= 0) {
            testResult.setTestNumber(this.testResults.size() + 1);
        }
        this.testResults.add(testResult);
        return this.tapLines.add(testResult);
    }

    public boolean addBailOut(BailOut bailOut) {
        this.bailOuts.add(bailOut);
        return this.tapLines.add(bailOut);
    }

    public boolean addComment(Comment comment) {
        this.comments.add(comment);
        return this.tapLines.add(comment);
    }

    protected boolean removeTapLine(TapResult tapLine) {
        return this.tapLines.remove(tapLine);
    }

    public boolean removeTestResult(TestResult testResult) {
        boolean flag = false;
        if (this.tapLines.remove(testResult)) {
            this.testResults.remove(testResult);
            flag = true;
        }
        return flag;
    }

    public boolean removeBailOut(BailOut bailOut) {
        boolean flag = false;
        if (this.tapLines.remove(bailOut)) {
            this.bailOuts.remove(bailOut);
            flag = true;
        }
        return flag;
    }

    public boolean removeComment(Comment comment) {
        boolean flag = false;
        if (this.tapLines.remove(comment)) {
            this.comments.remove(comment);
            flag = true;
        }
        return flag;
    }

    public int getNumberOfTapLines() {
        return this.tapLines.size();
    }

    public int getNumberOfTestResults() {
        return this.testResults.size();
    }

    public int getNumberOfBailOuts() {
        return this.bailOuts.size();
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public void setFooter(Footer footer) {
        this.footer = footer;
    }

    public boolean hasBailOut() {
        boolean isBailOut = false;
        for (TapResult tapLine : this.tapLines) {
            if (!(tapLine instanceof BailOut)) continue;
            isBailOut = true;
            break;
        }
        return isBailOut;
    }

    public Boolean containsOk() {
        Boolean containsOk = false;
        for (TestResult testResult : this.testResults) {
            if (!testResult.getStatus().equals((Object)StatusValues.OK)) continue;
            containsOk = true;
            break;
        }
        return containsOk;
    }

    public Boolean containsNotOk() {
        Boolean containsNotOk = false;
        for (TestResult testResult : this.testResults) {
            if (!testResult.getStatus().equals((Object)StatusValues.NOT_OK)) continue;
            containsNotOk = true;
            break;
        }
        return containsNotOk;
    }

    public Boolean containsBailOut() {
        return this.bailOuts.size() > 0;
    }

    public TestResult getTestResult(Integer testNumber) {
        TestResult foundTestResult = null;
        for (TestResult testResult : this.testResults) {
            if (testResult.getTestNumber() == null || !testResult.getTestNumber().equals(testNumber)) continue;
            foundTestResult = testResult;
            break;
        }
        return foundTestResult;
    }

    public int getNextTestNumber() {
        return this.testResults.size() + 1;
    }

    public String getSummary() {
        StringBuilder summary = new StringBuilder();
        if (this.header != null) {
            summary.append(this.header.toString());
            summary.append(LINE_SEPARATOR);
        }
        if (this.plan != null) {
            summary.append(this.plan.toString());
            summary.append(LINE_SEPARATOR);
        }
        Integer numberOfTestResults = this.getNumberOfTestResults();
        summary.append(numberOfTestResults);
        summary.append(" tests.");
        if (this.getNumberOfBailOuts() > 0) {
            summary.append("Contains Bail out!");
            summary.append(LINE_SEPARATOR);
        }
        if (this.footer != null) {
            summary.append("Footer: ");
            summary.append(this.footer.getText());
            summary.append(LINE_SEPARATOR);
        }
        return summary.toString();
    }

    public String getDetails() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.header != null) {
            sb.append(this.header.toString());
            sb.append(LINE_SEPARATOR);
        }
        sb.append(this.plan.toString());
        sb.append(LINE_SEPARATOR);
        for (TapResult tapLine : this.tapLines) {
            sb.append(tapLine.toString());
            sb.append(LINE_SEPARATOR);
        }
        if (this.footer != null) {
            sb.append(this.footer.toString());
        }
        return sb.toString();
    }
}

