/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.ext.junit;

import br.eti.kinoshita.tap4j.ext.junit.JUnitTestData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.yaml.snakeyaml.DumperOptions;

public final class JUnitYAMLishUtils {
    public static final SimpleDateFormat ISO_8061_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String LINE_SEPARATOR = DumperOptions.LineBreak.UNIX.getString();

    private JUnitYAMLishUtils() {
    }

    public static String getMessage(JUnitTestData testMethod) {
        return "JUnit 4.0 Test " + testMethod.getDescription().getDisplayName();
    }

    public static String getSeverity(JUnitTestData testMethod) {
        String severity = "~";
        if (testMethod.getFailException() != null) {
            severity = "High";
        }
        return severity;
    }

    public static String getSource(String testMethod, String testClass) {
        String source = testClass + "#" + testMethod;
        return source;
    }

    public static String getDatetime() {
        long currentTimeMillis = System.currentTimeMillis();
        Date date = new Date(currentTimeMillis);
        String iso8061Datetime = ISO_8061_DATE_FORMAT.format(date);
        return iso8061Datetime;
    }

    public static String getFile(JUnitTestData testMethod) {
        String file = JUnitYAMLishUtils.extractClassName(testMethod.getDescription());
        return file;
    }

    public static String getLine(JUnitTestData testMethod) {
        String line = "~";
        Throwable testException = testMethod.getFailException();
        if (testException != null) {
            StackTraceElement el;
            StringBuilder lookFor = new StringBuilder();
            lookFor.append(JUnitYAMLishUtils.extractClassName(testMethod.getDescription()));
            lookFor.append('.');
            lookFor.append(JUnitYAMLishUtils.extractMethodName(testMethod.getDescription()));
            lookFor.append('(');
            lookFor.append(JUnitYAMLishUtils.extractSimpleClassName(testMethod.getDescription()));
            lookFor.append(".java:");
            StackTraceElement[] els = testException.getStackTrace();
            for (int i = 0; i < els.length && (line = JUnitYAMLishUtils.getLineNumberFromExceptionTraceLine((el = els[i]).toString(), lookFor.toString())) == ""; ++i) {
            }
        }
        return line;
    }

    public static String getLineNumberFromExceptionTraceLine(String exceptionTraceLine, String substrToSearch) {
        String lineNumber = "";
        int index = exceptionTraceLine.indexOf(substrToSearch);
        if (index >= 0) {
            int length = substrToSearch.length() + index;
            if (exceptionTraceLine.lastIndexOf(41) > length) {
                lineNumber = exceptionTraceLine.substring(length, exceptionTraceLine.lastIndexOf(41));
            }
        }
        return lineNumber;
    }

    public static String getName(JUnitTestData testMethod) {
        String name = JUnitYAMLishUtils.extractMethodName(testMethod.getDescription());
        return name;
    }

    public static String getError(JUnitTestData testMethod) {
        String error = "~";
        Throwable t = testMethod.getFailException();
        if (t != null) {
            error = t.getMessage();
        }
        return error;
    }

    public static String getBacktrace(JUnitTestData testMethod) {
        StringBuilder stackTrace = new StringBuilder();
        Throwable throwable = testMethod.getFailException();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stackTraceString = sw.toString();
            stackTraceString = stackTraceString.trim().replaceAll("\\r\\n", "\n");
            StringTokenizer st = new StringTokenizer(stackTraceString, LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                String stackTraceLine = st.nextToken();
                stackTrace.append(stackTraceLine);
                stackTrace.append(LINE_SEPARATOR);
            }
        } else {
            stackTrace.append('~');
        }
        return stackTrace.toString();
    }

    public static String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        String regex = "^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$";
        Pattern PARENS = Pattern.compile(regex);
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }

    public static String extractSimpleClassName(Description description) {
        String simpleClassName = null;
        String className = JUnitYAMLishUtils.extractClassName(description);
        String[] splitClassName = className.split("\\.");
        if (splitClassName.length > 0) {
            simpleClassName = splitClassName[splitClassName.length - 1];
        }
        return simpleClassName;
    }

    public static String extractMethodName(Description description) {
        String methodName = null;
        String[] splitDisplayName = description.getDisplayName().split("\\(");
        if (splitDisplayName.length > 0) {
            methodName = splitDisplayName[0];
        }
        return methodName;
    }
}

