/* 
 * The MIT License
 * 
 * Copyright (c) 2010 Bruno P. Kinoshita <http://www.kinoshita.eti.br>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package br.eti.kinoshita.tap4j.consumer;


/**
 * This exception is thrown by the Tap Parser ({@link TapConsumer}).
 * 
 * @author Bruno P. Kinoshita <http://www.kinoshita.eti.br>
 * @since 20/09/2010
 * @see {@link TapConsumer}
 */
public class TapParserException extends Exception
{

	/**
	 * Default constructor.
	 */
	public TapParserException()
	{
	}

	/**
	 * Constructor with parameter.
	 * 
	 * @param message Exception message.
	 */
	public TapParserException(String message)
	{
		super(message);
	}

	/**
	 * Constructor with parameter.
	 * 
	 * @param cause Exception cause.
	 */
	public TapParserException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * Constructor with paramters.
	 * 
	 * @param message Exception message.
	 * @param cause Exception cause.
	 */
	public TapParserException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
