/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.model;

import br.eti.kinoshita.tap4j.model.BailOut;
import br.eti.kinoshita.tap4j.model.Comment;
import br.eti.kinoshita.tap4j.model.Footer;
import br.eti.kinoshita.tap4j.model.Header;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.TapResult;
import br.eti.kinoshita.tap4j.model.TestResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSet
implements Serializable {
    private Header header;
    private Plan plan;
    private List<TapResult> tapLines = new ArrayList<TapResult>();
    private List<TestResult> testResults = new ArrayList<TestResult>();
    private List<BailOut> bailOuts = new ArrayList<BailOut>();
    private List<Comment> comments = new ArrayList<Comment>();
    private Footer footer;

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public List<TapResult> getTapLines() {
        return this.tapLines;
    }

    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public List<BailOut> getBailOuts() {
        return this.bailOuts;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public boolean addTapLine(TapResult tapLine) {
        return this.tapLines.add(tapLine);
    }

    public boolean addTestResult(TestResult testResult) {
        this.testResults.add(testResult);
        return this.tapLines.add(testResult);
    }

    public boolean addBailOut(BailOut bailOut) {
        this.bailOuts.add(bailOut);
        return this.tapLines.add(bailOut);
    }

    public boolean addComment(Comment comment) {
        this.comments.add(comment);
        return this.tapLines.add(comment);
    }

    protected boolean removeTapLine(TapResult tapLine) {
        return this.tapLines.remove(tapLine);
    }

    public boolean removeTestResult(TestResult testResult) {
        if (this.tapLines.remove(testResult)) {
            this.testResults.remove(testResult);
            return true;
        }
        return false;
    }

    public boolean removeBailOut(BailOut bailOut) {
        if (this.tapLines.remove(bailOut)) {
            this.bailOuts.remove(bailOut);
            return true;
        }
        return false;
    }

    public boolean removeComment(Comment comment) {
        if (this.tapLines.remove(comment)) {
            this.comments.remove(comment);
            return true;
        }
        return false;
    }

    public int getNumberOfTapLines() {
        return this.tapLines.size();
    }

    public int getNumberOfTestResults() {
        return this.testResults.size();
    }

    public int getNumberOfBailOuts() {
        return this.bailOuts.size();
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public void setFooter(Footer footer) {
        this.footer = footer;
    }

    public boolean hasBailOut() {
        boolean isBailOut = false;
        for (TapResult tapLine : this.tapLines) {
            if (!(tapLine instanceof BailOut)) continue;
            isBailOut = true;
            break;
        }
        return isBailOut;
    }

    public String getSummary() {
        StringBuffer summary = new StringBuffer();
        if (this.header != null) {
            summary.append(this.header.toString());
            summary.append(System.getProperty("line.separator"));
        }
        if (this.plan != null) {
            summary.append(this.plan.toString());
            summary.append(System.getProperty("line.separator"));
        }
        Integer numberOfTestResults = this.getNumberOfTestResults();
        summary.append(numberOfTestResults + " tests.");
        if (this.getNumberOfBailOuts() > 0) {
            summary.append("Contains Bail out!");
            summary.append(System.getProperty("line.separator"));
        }
        if (this.footer != null) {
            summary.append("Footer: " + this.footer.getText());
            summary.append(System.getProperty("line.separator"));
        }
        return summary.toString();
    }

    public String getDetails() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.header != null) {
            sb.append(this.header.toString());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append(this.plan.toString());
        sb.append(System.getProperty("line.separator"));
        for (TapResult tapLine : this.tapLines) {
            sb.append(tapLine.toString());
            sb.append(System.getProperty("line.separator"));
        }
        if (this.footer != null) {
            sb.append(this.footer.toString());
        }
        return sb.toString();
    }
}

