/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.consumer;

import br.eti.kinoshita.tap4j.consumer.AbstractTapConsumer;
import br.eti.kinoshita.tap4j.consumer.TapParserException;
import br.eti.kinoshita.tap4j.model.BailOut;
import br.eti.kinoshita.tap4j.model.Comment;
import br.eti.kinoshita.tap4j.model.Directive;
import br.eti.kinoshita.tap4j.model.Footer;
import br.eti.kinoshita.tap4j.model.Header;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.SkipPlan;
import br.eti.kinoshita.tap4j.model.TapResult;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.model.TestSet;
import br.eti.kinoshita.tap4j.model.Text;
import br.eti.kinoshita.tap4j.util.DirectiveValues;
import br.eti.kinoshita.tap4j.util.StatusValues;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DefaultTapConsumer
extends AbstractTapConsumer {
    public static final String REGEX_HEADER = "\\s*TAP\\s*version\\s*(\\d+)\\s*(#\\s*(.*))?";
    public static final String REGEX_PLAN = "\\s*(\\d)+(\\.{2})(\\d)+\\s*(skip\\s*([^#]+))?\\s*(#\\s*(.*))?";
    public static final String REGEX_TEST_RESULT = "\\s*(ok|not ok)\\s*(\\d+)?\\s*([^#]*)?\\s*(#\\s*(SKIP|TODO)\\s*([^#]+))?\\s*(#\\s*(.*))?";
    public static final String REGEX_BAIL_OUT = "\\s*Bail out!\\s*([^#]+)?\\s*(#\\s*(.*))?";
    public static final String REGEX_COMMENT = "\\s*#\\s*(.*)";
    public static final String REGEX_FOOTER = "\\s*TAP\\s*([^#]*)?\\s*(#\\s*(.*))?";
    protected Pattern headerREGEX = Pattern.compile("\\s*TAP\\s*version\\s*(\\d+)\\s*(#\\s*(.*))?");
    protected Pattern planREGEX = Pattern.compile("\\s*(\\d)+(\\.{2})(\\d)+\\s*(skip\\s*([^#]+))?\\s*(#\\s*(.*))?");
    protected Pattern testResultREGEX = Pattern.compile("\\s*(ok|not ok)\\s*(\\d+)?\\s*([^#]*)?\\s*(#\\s*(SKIP|TODO)\\s*([^#]+))?\\s*(#\\s*(.*))?");
    protected Pattern bailOutREGEX = Pattern.compile("\\s*Bail out!\\s*([^#]+)?\\s*(#\\s*(.*))?");
    protected Pattern commentREGEX = Pattern.compile("\\s*#\\s*(.*)");
    protected Pattern footerREGEX = Pattern.compile("\\s*TAP\\s*([^#]*)?\\s*(#\\s*(.*))?");
    protected boolean isFirstLine = true;
    protected boolean isHeaderSet = false;
    protected boolean isPlanSet = false;
    protected boolean isPlanBeforeTestResult = false;
    protected String lastLine = null;

    public boolean isPlanBeforeTestResult() {
        return this.isPlanBeforeTestResult;
    }

    public void parseLine(String tapLine) throws TapParserException {
        if (StringUtils.isEmpty((String)tapLine)) {
            return;
        }
        Matcher matcher = null;
        matcher = this.commentREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.extractComment(matcher);
            return;
        }
        this.lastLine = tapLine;
        matcher = this.headerREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPHeaderParsingLocationAndDuplicity();
            this.extractHeader(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = this.planREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPPlanDuplicity();
            this.checkIfTAPPlanIsSetBeforeTestResultsOrBailOut();
            this.extractPlan(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = this.testResultREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.extractTestResult(matcher);
            return;
        }
        matcher = this.bailOutREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.extractBailOut(matcher);
            return;
        }
        matcher = this.footerREGEX.matcher(tapLine);
        if (matcher.matches()) {
            this.extractFooter(matcher);
            return;
        }
        Text text = new Text(tapLine);
        this.tapLines.add(text);
    }

    private void checkIfTAPPlanIsSetBeforeTestResultsOrBailOut() {
        if (this.testResults.size() <= 0 && this.bailOuts.size() <= 0) {
            this.isPlanBeforeTestResult = true;
        }
    }

    private void checkTAPHeaderParsingLocationAndDuplicity() throws TapParserException {
        if (this.isHeaderSet) {
            throw new TapParserException("Duplicated TAP Header found.");
        }
        if (!this.isFirstLine) {
            throw new TapParserException("Invalid position of TAP Header. It must be the first element (apart of Comments) in the TAP Stream.");
        }
        this.isHeaderSet = true;
    }

    private void checkTAPPlanDuplicity() throws TapParserException {
        if (this.isPlanSet) {
            throw new TapParserException("Duplicated TAP Plan found.");
        }
        this.isPlanSet = true;
    }

    private void checkTAPPlanPosition() throws TapParserException {
        if (!this.isPlanBeforeTestResult) {
            Matcher matcher = this.planREGEX.matcher(this.lastLine);
            if (matcher.matches()) {
                return;
            }
            throw new TapParserException("Invalid position of TAP Plan.");
        }
    }

    private void extractHeader(Matcher matcher) {
        Integer version = Integer.parseInt(matcher.group(1));
        Header header = new Header(version);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            header.setComment(comment);
        }
        this.header = header;
    }

    private void extractPlan(Matcher matcher) {
        String commentToken;
        Integer initialTest = Integer.parseInt(matcher.group(1));
        Integer lastTest = Integer.parseInt(matcher.group(3));
        Plan plan = null;
        plan = new Plan(initialTest, lastTest);
        String skipToken = matcher.group(4);
        if (skipToken != null) {
            String reason = matcher.group(5);
            SkipPlan skip = new SkipPlan(reason);
            plan.setSkip(skip);
        }
        if ((commentToken = matcher.group(6)) != null) {
            String text = matcher.group(7);
            Comment comment = new Comment(text);
            plan.setComment(comment);
        }
        this.plan = plan;
    }

    private void extractTestResult(Matcher matcher) {
        String commentToken;
        TestResult testResult = null;
        String okOrNotOk = matcher.group(1);
        StatusValues status = null;
        status = okOrNotOk.trim().equals("ok") ? StatusValues.OK : StatusValues.NOT_OK;
        Integer testNumber = Integer.parseInt(matcher.group(2));
        testResult = new TestResult(status, testNumber);
        testResult.setDescription(matcher.group(3));
        String directiveToken = matcher.group(4);
        if (directiveToken != null) {
            String directiveText = matcher.group(5);
            DirectiveValues directiveValue = null;
            directiveValue = directiveText.trim().equals("TODO") ? DirectiveValues.TODO : DirectiveValues.SKIP;
            String reason = matcher.group(6);
            Directive directive = new Directive(directiveValue, reason);
            testResult.setDirective(directive);
        }
        if ((commentToken = matcher.group(7)) != null) {
            String text = matcher.group(8);
            Comment comment = new Comment(text);
            testResult.setComment(comment);
        }
        this.testResults.add(testResult);
        this.tapLines.add(testResult);
    }

    private void extractBailOut(Matcher matcher) {
        String reason = matcher.group(1);
        BailOut bailOut = new BailOut(reason);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            bailOut.setComment(comment);
        }
        this.bailOuts.add(bailOut);
        this.tapLines.add(bailOut);
    }

    private void extractComment(Matcher matcher) {
        String text = matcher.group(1);
        Comment comment = new Comment(text);
        this.comments.add(comment);
        this.tapLines.add(comment);
    }

    private void extractFooter(Matcher matcher) {
        String text = matcher.group(1);
        Footer footer = new Footer(text);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String commentText = matcher.group(3);
            Comment comment = new Comment(commentText);
            footer.setComment(comment);
        }
        this.footer = footer;
    }

    public void parseTapStream(String tapStream) throws TapParserException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapStream);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                this.parseLine(line);
            }
            this.checkTAPPlanPosition();
        }
        catch (Exception e) {
            throw new TapParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public void parseFile(File tapFile) throws TapParserException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapFile);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                this.parseLine(line);
            }
            this.checkTAPPlanPosition();
        }
        catch (Exception e) {
            throw new TapParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public void printSummary(PrintWriter pw) {
        TestSet testSet = this.getTestSet();
        String summary = testSet.getSummary();
        pw.println(summary);
    }

    public void printSummary(PrintStream ps) {
        TestSet testSet = this.getTestSet();
        String summary = testSet.getSummary();
        ps.println(summary);
    }

    public void printDetails(PrintWriter pw) {
        TestSet testSet = this.getTestSet();
        if (testSet.getHeader() != null) {
            pw.println(testSet.getHeader().toString());
        }
        if (testSet.getPlan() != null) {
            pw.println(testSet.getPlan().toString());
        }
        List<TapResult> tapLines = testSet.getTapLines();
        for (TapResult tapLine : tapLines) {
            pw.println(tapLine.toString());
        }
        if (testSet.getFooter() != null) {
            pw.println(testSet.getFooter().toString());
        }
    }

    public void printDetails(PrintStream ps) {
        TestSet testSet = this.getTestSet();
        if (testSet.getHeader() != null) {
            ps.println(testSet.getHeader().toString());
        }
        if (testSet.getPlan() != null) {
            ps.println(testSet.getPlan().toString());
        }
        List<TapResult> tapLines = testSet.getTapLines();
        for (TapResult tapLine : tapLines) {
            ps.println(tapLine.toString());
        }
        if (testSet.getFooter() != null) {
            ps.println(testSet.getFooter().toString());
        }
    }
}

