/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.tap4j.consumer;

import br.eti.kinoshita.tap4j.consumer.TapConsumer;
import br.eti.kinoshita.tap4j.model.BailOut;
import br.eti.kinoshita.tap4j.model.Comment;
import br.eti.kinoshita.tap4j.model.Footer;
import br.eti.kinoshita.tap4j.model.Header;
import br.eti.kinoshita.tap4j.model.Plan;
import br.eti.kinoshita.tap4j.model.TapResult;
import br.eti.kinoshita.tap4j.model.TestResult;
import br.eti.kinoshita.tap4j.model.TestSet;
import br.eti.kinoshita.tap4j.util.StatusValues;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTapConsumer
implements TapConsumer {
    protected TestSet testSet;
    protected Header header;
    protected Plan plan;
    protected List<TapResult> tapLines = new ArrayList<TapResult>();
    protected List<TestResult> testResults = new ArrayList<TestResult>();
    protected List<BailOut> bailOuts = new ArrayList<BailOut>();
    protected List<Comment> comments = new ArrayList<Comment>();
    protected Footer footer;

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public Plan getPlan() {
        return this.plan;
    }

    @Override
    public List<TapResult> getTapLines() {
        return this.tapLines;
    }

    @Override
    public Integer getNumberOfTapLines() {
        return this.tapLines.size();
    }

    @Override
    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    @Override
    public TestResult getTestResult(Integer testNumber) {
        TestResult foundTestResult = null;
        for (TestResult testResult : this.testResults) {
            if (testResult.getTestNumber() == null || !testResult.getTestNumber().equals(testNumber)) continue;
            foundTestResult = testResult;
            break;
        }
        return foundTestResult;
    }

    @Override
    public Boolean containsOk() {
        Boolean containsOk = false;
        for (TestResult testResult : this.testResults) {
            if (!testResult.getStatus().equals((Object)StatusValues.OK)) continue;
            containsOk = true;
            break;
        }
        return containsOk;
    }

    @Override
    public Boolean containsNotOk() {
        Boolean containsNotOk = false;
        for (TestResult testResult : this.testResults) {
            if (!testResult.getStatus().equals((Object)StatusValues.NOT_OK)) continue;
            containsNotOk = true;
            break;
        }
        return containsNotOk;
    }

    @Override
    public Integer getNumberOfTestResults() {
        return this.testResults.size();
    }

    @Override
    public Boolean containsBailOut() {
        return this.bailOuts.size() > 0;
    }

    @Override
    public List<BailOut> getBailOuts() {
        return this.bailOuts;
    }

    @Override
    public Integer getNumberOfBailOuts() {
        return this.bailOuts.size();
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Integer getNumberOfComments() {
        return this.comments.size();
    }

    @Override
    public Footer getFooter() {
        return this.footer;
    }

    @Override
    public TestSet getTestSet() {
        this.testSet = new TestSet();
        this.testSet.setHeader(this.header);
        this.testSet.setPlan(this.plan);
        for (TapResult tapLine : this.tapLines) {
            this.testSet.addTapLine(tapLine);
        }
        this.testSet.setFooter(this.footer);
        return this.testSet;
    }
}

