/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.selenium.util;

import br.eti.kinoshita.selenium.util.SeleniumWebTestException;
import com.google.common.base.Function;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Function<WebDriver, WebElement> presenceOfElement(final By locator) {
        return new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return driver.findElement(locator);
            }
        };
    }

    public static Function<WebDriver, Select> presenceOfSelectIndexAvailable(final By locator, final int index) {
        return new Function<WebDriver, Select>(){

            public Select apply(WebDriver driver) {
                Select select;
                WebElement foundElement = driver.findElement(locator);
                if (foundElement != null && (select = new Select(foundElement)).getOptions().size() >= index) {
                    return select;
                }
                return null;
            }
        };
    }

    public static void executeJavascript(WebDriver driver, String jsCommand) {
        ((JavascriptExecutor)driver).executeScript(jsCommand, new Object[0]);
    }

    public static WebElement waitForAssyncContent(WebDriver driver, By by, Long timeout) throws NoSuchElementException {
        long end = System.currentTimeMillis() + timeout;
        WebElement renderedWebElement = null;
        while (System.currentTimeMillis() < end) {
            try {
                renderedWebElement = driver.findElement(by);
            }
            catch (NoSuchElementException nsee) {
                LOGGER.debug(nsee.getMessage(), (Throwable)nsee);
            }
            if (renderedWebElement != null && renderedWebElement.isEnabled() && renderedWebElement.isDisplayed()) {
                return renderedWebElement;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                LOGGER.debug(ie.getMessage(), (Throwable)ie);
            }
        }
        if (renderedWebElement == null) {
            throw new NoSuchElementException("Could not locate assync content");
        }
        try {
            if (renderedWebElement.isDisplayed()) {
                throw new NoSuchElementException("Element is not being displayed");
            }
        }
        catch (Throwable t) {
            LOGGER.debug(t.getMessage(), t);
        }
        return renderedWebElement;
    }

    public static void waitForSelectIndex(Select select, Integer index, Long timeout) {
        Long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end && select.getOptions().size() < index) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void executeJavascriptClick(WebDriver driver, String elementID) {
        String jsCommand = "var el = document.getElementById('" + elementID + "'); var evt; if ( document.createEvent ) { evt = document.createEvent('MouseEvents'); evt.initMouseEvent('click', true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null); if ( el != null ) { el.dispatchEvent( evt ); } } else if ( el != null && el.fireEvent ) { el.fireEvent('onclick'); }";
        ((JavascriptExecutor)driver).executeScript(jsCommand, new Object[0]);
    }

    public static void executeJavascriptClickIE(WebDriver driver, String elementID) {
        String jsCommand = "var el = document.getElementById('" + elementID + "'); el.click();";
        ((JavascriptExecutor)driver).executeScript(jsCommand, new Object[0]);
    }

    public static void sleep(Long timeToSleep) {
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            throw new SeleniumWebTestException(e);
        }
    }

    public static void clickAndWaitForElementAttributeChange(WebElement elementToClick, String attributeType, String attributeValue) {
        for (int i = 0; i < 10; ++i) {
            elementToClick.click();
            String elementAttribute = elementToClick.getAttribute(attributeType);
            if (!StringUtils.isNotBlank((String)elementAttribute) || !elementAttribute.contains(attributeValue)) break;
            Utils.sleep(750L);
        }
    }

    public static void clickAndWaitForElementToDesappear(WebElement elementToClick) {
        for (int i = 0; i < 10; ++i) {
            try {
                elementToClick.click();
                Utils.sleep(750L);
                continue;
            }
            catch (ElementNotVisibleException e) {
                break;
            }
        }
    }

    public static void selectRadioButton(WebElement radioToClick) {
        for (int i = 0; i < 10; ++i) {
            radioToClick.click();
            if (radioToClick.isSelected()) break;
        }
    }
}

