/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.selenium;

import com.google.inject.Binder;
import com.google.inject.Module;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumGuiceModule
implements Module {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SeleniumGuiceModule.class);
    protected static final Configuration CONFIGURATION = new CompositeConfiguration();
    private static final WebDriver DRIVER;

    public void configure(Binder binder) {
        binder.bind(WebDriver.class).toInstance((Object)DRIVER);
        binder.bind(Configuration.class).toInstance((Object)CONFIGURATION);
    }

    static {
        try {
            PropertiesConfiguration propertiesConfig = new PropertiesConfiguration("selenium.properties");
            ((CompositeConfiguration)CONFIGURATION).addConfiguration((Configuration)propertiesConfig);
            ((CompositeConfiguration)CONFIGURATION).addConfiguration((Configuration)new SystemConfiguration());
            ((CompositeConfiguration)CONFIGURATION).setThrowExceptionOnMissing(Boolean.TRUE.booleanValue());
        }
        catch (ConfigurationException ce) {
            LOGGER.error("Failed to load selenium.properties: " + ce.getMessage(), (Throwable)ce);
        }
        String browser = CONFIGURATION.getString("selenium.browser");
        DRIVER = !StringUtils.isBlank((String)browser) ? (browser.equals("firefox") ? new FirefoxDriver() : (browser.equals("html") ? new HtmlUnitDriver() : (browser.equals("chrome") ? new ChromeDriver() : new InternetExplorerDriver()))) : new InternetExplorerDriver();
    }
}

