/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.selenium;

import br.eti.kinoshita.selenium.SeleniumWebTest;
import br.eti.kinoshita.selenium.util.SeleniumWebTestException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;

public abstract class DataDrivenSeleniumWebTest
extends SeleniumWebTest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DataDrivenSeleniumWebTest.class);

    public String getTableName() {
        return "Table";
    }

    public abstract String getSheetName();

    @DataProvider(name="DataExcel")
    public Object[][] getDataFromXLS() throws SeleniumWebTestException {
        Object[][] xlsDataArray = this.getTableArray(this.getSheetName(), this.getTableName());
        LOGGER.debug("Data-driven test object[][] array: " + Arrays.toString((Object[])xlsDataArray));
        return xlsDataArray;
    }

    protected String[][] getTableArray(String sheetName, String tableName) throws SeleniumWebTestException {
        String[][] tableArray = null;
        String xlsFile = this.getConfiguration().getString("selenium.xls");
        LOGGER.debug("Opening excel file " + xlsFile);
        String xlsFilePath = null;
        try {
            xlsFilePath = ClassLoader.getSystemResource(xlsFile).getFile();
            Workbook workbook = Workbook.getWorkbook((File)new File(xlsFilePath));
            Sheet sheet = workbook.getSheet(sheetName);
            Cell tableStart = sheet.findCell(tableName);
            int startRow = tableStart.getRow();
            int startCol = tableStart.getColumn();
            Cell tableEnd = sheet.findCell(tableName, startCol + 1, startRow + 1, 100, 64000, false);
            int endRow = tableEnd.getRow();
            int endCol = tableEnd.getColumn();
            LOGGER.debug("startRow=" + startRow + ", endRow=" + endRow + ", startCol=" + startCol + ", endCol=" + endCol);
            tableArray = new String[endRow - startRow - 1][endCol - startCol - 1];
            int ci = 0;
            int i = startRow + 1;
            while (i < endRow) {
                int cj = 0;
                int j = startCol + 1;
                while (j < endCol) {
                    tableArray[ci][cj] = sheet.getCell(j, i).getContents();
                    ++j;
                    ++cj;
                }
                ++i;
                ++ci;
            }
            if (tableArray.length <= 0) {
                throw new SeleniumWebTestException("Empty excel data.");
            }
            return tableArray;
        }
        catch (IOException ioe) {
            LOGGER.error("IO Exception retrieving table array from Excel: " + ioe.getMessage(), (Throwable)ioe);
            throw new SeleniumWebTestException(ioe);
        }
        catch (BiffException be) {
            LOGGER.error("Internal error retrieving table array from Excel: " + be.getMessage(), (Throwable)be);
            throw new SeleniumWebTestException(be);
        }
    }
}

