/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.security;

import br.eti.clairton.security.Lock;
import br.eti.clairton.security.Repository;
import br.eti.clairton.security.Service;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class ServiceInMemory
implements Service {
    private static final Logger logger = Logger.getLogger(ServiceInMemory.class.getSimpleName());
    private final Lock lock;

    public ServiceInMemory(Lock lock) {
        this.lock = lock;
    }

    @Override
    public Boolean found(String user) {
        return Repository.getRepository().containsKey(user);
    }

    @Override
    public Boolean update(String user, String currentPassword, String newPassword) {
        if (this.lock.isValid(user, currentPassword).booleanValue()) {
            logger.log(Level.FINE, "Atualizando senha usu\u00e1rio {}", user);
            Repository.getRepository().put(user, newPassword);
            return this.lock.isValid(user, newPassword);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean create(String user, String password) {
        Repository.getRepository().put(user, password);
        logger.log(Level.FINE, "Criado usu\u00e1rio {}", user);
        return this.lock.isValid(user, password);
    }

    @Override
    public Boolean remove(String user) {
        Boolean result = Repository.getRepository().remove(user) != null;
        if (result.booleanValue()) {
            logger.log(Level.FINE, "Removido usu\u00e1rio {}", user);
        } else {
            logger.log(Level.FINE, "Usu\u00e1rio {} n\u00e3o encontrado", user);
        }
        return result;
    }

    @Override
    public Boolean reset(String user, String password) {
        Repository.getRepository().put(user, password);
        return this.lock.isValid(user, password);
    }

    @Override
    public void disable(String user) {
        Repository.getRepository().remove(user);
    }

    @Override
    public void enable(String user) {
        Repository.getRepository().put(user, null);
    }
}

