/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.security;

import br.eti.clairton.security.Authenticated;
import br.eti.clairton.security.Locksmith;
import br.eti.clairton.security.Token;
import br.eti.clairton.security.UnauthenticatedException;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.constraints.NotNull;

@Interceptor
@Authenticated
public class LockInterceptor {
    private final Locksmith locksmith;
    private final String token;

    @Inject
    public LockInterceptor(@NotNull Locksmith locksmith, @Token String token) {
        this.locksmith = locksmith;
        this.token = token;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Throwable {
        try {
            if (this.locksmith.isValid(this.token).booleanValue()) {
                return context.proceed();
            }
            throw new UnauthenticatedException("Token " + this.token + " is invalid");
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

