/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.security;

import br.eti.clairton.security.App;
import br.eti.clairton.security.Extractor;
import br.eti.clairton.security.Gate;
import br.eti.clairton.security.Protected;
import br.eti.clairton.security.UnauthorizedException;
import br.eti.clairton.security.User;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Protected
public class GateInterceptor {
    private final Logger logger = Logger.getLogger(GateInterceptor.class.getSimpleName());
    private final String user;
    private final String app;
    private final Gate gate;
    private final Extractor extractor;

    @Inject
    public GateInterceptor(@App String app, @User String user, Gate gate, Extractor extractor) {
        this.app = app;
        this.user = user;
        this.gate = gate;
        this.extractor = extractor;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Throwable {
        Object target = context.getTarget();
        String resource = this.extractor.getResource(target);
        String operation = this.extractor.getOperation(context.getMethod());
        this.logger.log(Level.FINE, "Interceptando {}#{}", new Object[]{target.getClass().getSimpleName(), operation});
        if (this.gate.isOpen(this.user, this.app, resource, operation).booleanValue()) {
            try {
                return context.proceed();
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw new UnauthorizedException(this.user, this.app, resource, operation);
    }
}

