/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.security;

import br.eti.clairton.security.Operation;
import br.eti.clairton.security.Resource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.Matcher;
import net.vidageek.mirror.list.dsl.MirrorList;

@ApplicationScoped
public class Extractor {
    private final Mirror mirror = new Mirror();
    private final Matcher<Method> matcher = new Matcher<Method>(){

        public boolean accepts(Method method) {
            return method.isAnnotationPresent(Resource.class);
        }
    };

    public String getOperation(Method method) {
        if (method.isAnnotationPresent(Operation.class)) {
            Operation annotation = method.getAnnotation(Operation.class);
            return annotation.value();
        }
        return method.getName();
    }

    public String getResource(Object target) {
        Class<?> type = target.getClass();
        if (type.isAnnotationPresent(Resource.class)) {
            Resource annotation = type.getAnnotation(Resource.class);
            if (annotation.value().isEmpty()) {
                throw new IllegalStateException(Resource.class + " annotation must be filled in type " + type);
            }
            return annotation.value();
        }
        String typeName = this.withoutProxy(type.getName());
        MirrorList methods = this.mirror.on(typeName).reflectAll().methods().matching(this.matcher);
        if (methods.size() > 1) {
            throw new IllegalArgumentException("The type " + type + " must be annoted twice with " + Resource.class);
        }
        if (methods.size() == 1) {
            try {
                Method method = (Method)methods.get(0);
                String resource = (String)method.invoke(target, new Object[0]);
                if (resource == null || resource.isEmpty()) {
                    Object instance = this.mirror.on(typeName).invoke().constructor().withoutArgs();
                    resource = (String)method.invoke(instance, new Object[0]);
                }
                return resource;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        String controller = this.withoutProxy(target.getClass().getSimpleName());
        String model = controller.split("Controller*.")[0];
        return model.substring(0, 1).toLowerCase() + model.substring(1);
    }

    public String getResource(Class<?> type) {
        Constructor<?> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Deve haver um construtor padr\u00e3o", e);
        }
        constructor.setAccessible(true);
        try {
            Object target = constructor.newInstance(new Object[0]);
            return this.getResource(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Erro ao recuperar o nome do recurso pelo tipo do controller", e);
        }
    }

    private String withoutProxy(String className) {
        return className.split("\\$Proxy\\$")[0].split("_\\$")[0];
    }
}

