/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository;

import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Comparators;
import br.eti.clairton.repository.Operator;
import br.eti.clairton.repository.Operators;
import br.eti.clairton.repository.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;

public class PredicateBuilder {
    private Object value;
    private JoinType join;
    private Comparator comparator;
    private Operator operator;
    private List<Attribute<?, ?>> attributes;

    public PredicateBuilder() {
        this.defaultValues();
    }

    public PredicateBuilder value(Object value) {
        this.value = value;
        return this;
    }

    public PredicateBuilder join(JoinType join) {
        this.join = join;
        return this;
    }

    public PredicateBuilder comparator(Comparator comparator) {
        this.comparator = comparator;
        return this;
    }

    public PredicateBuilder attributes(List<Attribute<?, ?>> attributes) {
        this.attributes.addAll(attributes);
        return this;
    }

    public PredicateBuilder attribute(Attribute<?, ?> ... attributes) {
        return this.attributes(Arrays.asList(attributes));
    }

    public Predicate build() {
        Predicate predicate = new Predicate(this.value, this.join, this.comparator, this.operator, this.attributes.toArray(new Attribute[this.attributes.size()]));
        this.defaultValues();
        return predicate;
    }

    private void defaultValues() {
        this.value = null;
        this.join = JoinType.INNER;
        this.comparator = Comparators.EQUAL;
        this.attributes = new ArrayList();
        this.operator = Operators.AND;
    }

    public PredicateBuilder operator(Operator operator) {
        this.operator = operator;
        return this;
    }
}

