/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository;

import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Comparators;
import br.eti.clairton.repository.Operator;
import br.eti.clairton.repository.Operators;
import java.io.Serializable;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.validation.constraints.NotNull;

public class Predicate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Attribute<?, ?>[] attributes;
    private JoinType joinType = JoinType.INNER;
    private Comparator comparator = Comparators.EQUAL;
    private Operator operator = Operators.AND;

    public <T> Predicate(@NotNull T value, Attribute<?, ?> ... attributes) {
        this(value, JoinType.INNER, Comparators.EQUAL, Operators.AND, attributes);
    }

    public <T> Predicate(@NotNull Operator operator, @NotNull T value, Attribute<?, ?> ... attribute) {
        this(value, JoinType.INNER, Comparators.EQUAL, operator, attribute);
    }

    public <T> Predicate(@NotNull T value, @NotNull Comparator comparator, Attribute<?, ?> ... attribute) {
        this(value, JoinType.INNER, comparator, Operators.AND, attribute);
    }

    public Predicate(Attribute<?, ?> ... attribute) {
        this(null, JoinType.INNER, Comparators.EQUAL, Operators.AND, attribute);
    }

    public Predicate(@NotNull Comparator comparator, Attribute<?, ?> ... attribute) {
        this(null, JoinType.INNER, comparator, Operators.AND, attribute);
    }

    public Predicate(@NotNull JoinType joinType, @NotNull Comparator comparator, Attribute<?, ?> ... attribute) {
        this(null, joinType, comparator, Operators.AND, attribute);
    }

    public <T> Predicate(@NotNull T value, JoinType joinType, @NotNull Comparator comparator, @NotNull Operator operator, Attribute<?, ?> ... attribute) {
        this.value = value;
        this.attributes = attribute;
        this.joinType = joinType;
        this.comparator = comparator;
        this.operator = operator;
    }

    public Attribute<?, ?>[] getAttributes() {
        return this.attributes;
    }

    public Attribute<?, ?> getAttribute() {
        return this.attributes[0];
    }

    public <T> void setValue(@NotNull T value) {
        this.value = value;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(@NotNull JoinType joinType) {
        this.joinType = joinType;
    }

    public void setValueObject(@NotNull Object value) {
        this.value = value;
    }

    public String toString() {
        return this.joinType.toString() + " " + this.path() + " " + this.comparator.toString() + " " + this.value.toString();
    }

    private String path() {
        StringBuilder path = new StringBuilder();
        String separator = "";
        for (Attribute<?, ?> a : this.attributes) {
            path.append(separator + a.getName());
            separator = ".";
        }
        return path.toString();
    }
}

