/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository;

import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.EndsWith;
import br.eti.clairton.repository.Equal;
import br.eti.clairton.repository.EqualIgnoreCase;
import br.eti.clairton.repository.Exist;
import br.eti.clairton.repository.GreaterThan;
import br.eti.clairton.repository.GreaterThanOrEqual;
import br.eti.clairton.repository.LessThan;
import br.eti.clairton.repository.LessThanOrEqual;
import br.eti.clairton.repository.Like;
import br.eti.clairton.repository.NotEndsWith;
import br.eti.clairton.repository.NotEqual;
import br.eti.clairton.repository.NotLike;
import br.eti.clairton.repository.NotNull;
import br.eti.clairton.repository.NotStartsWith;
import br.eti.clairton.repository.Null;
import br.eti.clairton.repository.StartsWith;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;

public enum Comparators implements Comparator
{
    GREATER_THAN_OR_EQUAL(new GreaterThanOrEqual()),
    LESS_THAN_OR_EQUAL(new LessThanOrEqual()),
    EQUAL(new Equal()),
    EQUAL_IGNORE_CASE(new EqualIgnoreCase()),
    NOT_NULL(new NotNull()),
    NULL(new Null()),
    EXIST(new Exist()),
    NOT_EQUAL(new NotEqual()),
    LIKE(new Like()),
    STARTS_WITH(new StartsWith()),
    NOT_STARTS_WITH(new NotStartsWith()),
    ENDS_WITH(new EndsWith()),
    NOT_ENDS_WITH(new NotEndsWith()),
    NOT_LIKE(new NotLike()),
    LESS_THAN(new LessThan()),
    GREATER_THAN(new GreaterThan());

    private final Comparator comparator;
    private static Map<String, Comparator> repository;

    private Comparators(Comparator comparator) {
        this.comparator = comparator;
        this.put();
    }

    public String toString() {
        return this.comparator.toString();
    }

    @Override
    public Predicate build(CriteriaBuilder cb, Expression<?> x, Object y) {
        return this.comparator.build(cb, x, y);
    }

    public static Comparator bySymbol(String symbol) {
        if (repository.containsKey(symbol)) {
            return repository.get(symbol);
        }
        throw new RuntimeException("Operator " + symbol + " n\u00e3o encontrado");
    }

    private void put() {
        if (repository == null) {
            repository = new HashMap<String, Comparator>();
        }
        repository.put(this.comparator.toString(), this.comparator);
    }
}

