/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository;

import br.eti.clairton.repository.AttributeNotBeEmptyException;
import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Join;
import br.eti.clairton.repository.Predicate;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;

@Vetoed
public class Joinner {
    public static final Map<PluralAttribute.CollectionType, Join> JOINS = new HashMap<PluralAttribute.CollectionType, Join>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(PluralAttribute.CollectionType.LIST, Join.LIST);
            this.put(PluralAttribute.CollectionType.COLLECTION, Join.COLLECTION);
            this.put(PluralAttribute.CollectionType.SET, Join.SET);
            this.put(PluralAttribute.CollectionType.MAP, Join.MAP);
        }
    };
    protected final Map<From<?, ?>, Map<Attribute<?, ?>, javax.persistence.criteria.Join<?, ?>>> index = new HashMap();
    protected final CriteriaBuilder builder;
    protected final From<?, ?> from;
    protected From<?, ?> fromLast;

    public Joinner(CriteriaBuilder builder, From<?, ?> from) {
        this.builder = builder;
        this.from = from;
    }

    public <Y> Path<Y> select(JoinType joinType, Attribute<?, ?> ... attributes) {
        Path<Y> path = this.join(joinType, attributes);
        return path;
    }

    public <Y> Expression<Y> select(Attribute<?, ?> ... attributes) {
        return this.join(JoinType.INNER, attributes);
    }

    public javax.persistence.criteria.Predicate join(Predicate predicate) {
        Comparator comparator = predicate.getComparator();
        Attribute<?, ?>[] attributes = predicate.getAttributes();
        JoinType joinType = predicate.getJoinType();
        return this.join(joinType, comparator, predicate.getValue(), attributes);
    }

    public javax.persistence.criteria.Predicate join(JoinType joinType, Comparator comparator, Object value, Attribute<?, ?> ... attributes) {
        Attribute<?, ?> attribute;
        this.fromLast = this.from;
        if (attributes.length == 0) {
            String message = "Must be have a attribute in predicate";
            throw new IllegalStateException("Must be have a attribute in predicate");
        }
        if (attributes.length == 1) {
            attribute = attributes[0];
        } else {
            Integer i = 1;
            Integer j = attributes.length - 1;
            Attribute<?, ?> a = attributes[0];
            javax.persistence.criteria.Join<?, ?> join = this.join(this.fromLast, joinType, a);
            while (i < j) {
                a = attributes[i];
                join = this.join((From)join, joinType, a);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            attribute = attributes[i];
            this.fromLast = join;
        }
        Path path = this.get(this.fromLast, attribute);
        javax.persistence.criteria.Predicate joinPredicate = comparator.build(this.builder, (Expression<?>)path, value);
        return joinPredicate;
    }

    public javax.persistence.criteria.Join<?, ?> join(From<?, ?> from, Attribute<?, ?> attribute) {
        javax.persistence.criteria.Join<?, ?> join = this.join(from, JoinType.INNER, attribute);
        return join;
    }

    public <T, Y> javax.persistence.criteria.Join<T, Y> join(From<T, Y> from, JoinType joinType, Attribute<?, ?> attribute) {
        javax.persistence.criteria.Join<T, Y> join;
        if (this.isReady(from, attribute).booleanValue()) {
            javax.persistence.criteria.Join<T, Y> j;
            join = j = this.searchIndex(from, attribute);
        } else {
            if (attribute.isCollection()) {
                PluralAttribute pAttribute = (PluralAttribute)attribute;
                join = JOINS.get(pAttribute.getCollectionType()).join(from, joinType, pAttribute);
            } else {
                javax.persistence.criteria.Join<T, Y> j;
                SingularAttribute sAttribute = (SingularAttribute)attribute;
                join = j = from.join(sAttribute, joinType);
            }
            this.addIndex(from, attribute, join);
        }
        return join;
    }

    protected <Y> Expression<Y> join(Attribute<?, ?> ... attributes) {
        return this.join(JoinType.INNER, attributes);
    }

    protected <Y> Path<Y> join(JoinType joinType, Attribute<?, ?> ... attributes) {
        Attribute<?, ?> attribute;
        From<?, ?> from = this.from;
        if (attributes.length == 0) {
            throw new AttributeNotBeEmptyException();
        }
        if (attributes.length == 1) {
            attribute = attributes[0];
            if (attribute.isAssociation() && !this.isReady(from, attribute).booleanValue()) {
                this.addIndex(from, attribute, this.join(from, joinType, attribute));
            }
        } else {
            Integer i = 1;
            Integer j = attributes.length - 1;
            Attribute<?, ?> a = attributes[0];
            javax.persistence.criteria.Join<?, ?> join = this.join(from, joinType, a);
            while (i < j) {
                a = attributes[i];
                join = this.join((From)join, joinType, a);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            attribute = attributes[i];
            from = join;
        }
        Path<Y> path = this.get(from, attribute);
        return path;
    }

    public Boolean isReady(From<?, ?> origin, Attribute<?, ?> destiny) {
        return this.index.containsKey(origin) && this.index.get(origin).containsKey(destiny);
    }

    public javax.persistence.criteria.Join<?, ?> searchIndex(From<?, ?> origin, Attribute<?, ?> destiny) {
        return this.index.get(origin).get(destiny);
    }

    public void addIndex(From<?, ?> origin, Attribute<?, ?> destiny, javax.persistence.criteria.Join<?, ?> value) {
        if (!this.index.containsKey(origin)) {
            this.index.put(origin, new HashMap());
        }
        this.index.get(origin).put(destiny, value);
    }

    protected <T, Y> Path<Y> get(From<?, ?> from, Attribute<?, ?> attribute) {
        javax.persistence.criteria.Join path;
        if (attribute.isCollection()) {
            path = from.join(attribute.getName());
        } else {
            Path p = from.get((SingularAttribute)attribute);
            path = p;
        }
        return path;
    }

    protected Map<From<?, ?>, Map<Attribute<?, ?>, javax.persistence.criteria.Join<?, ?>>> getIndex() {
        return this.index;
    }
}

