/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository;

import br.eti.clairton.paginated.collection.Meta;
import br.eti.clairton.paginated.collection.PaginatedCollection;
import br.eti.clairton.paginated.collection.PaginatedList;
import br.eti.clairton.paginated.collection.PaginatedMetaList;
import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Comparators;
import br.eti.clairton.repository.Joinner;
import br.eti.clairton.repository.Operator;
import br.eti.clairton.repository.Order;
import br.eti.clairton.repository.Predicate;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.transaction.Transactional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Dependent
public class Repository
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Repository.class.getName());
    private final Map<String, Object> hints = new HashMap<String, Object>();
    private EntityManager em;
    protected Root<?> from;
    private Expression<?> selection;
    private CriteriaQuery<?> criteriaQuery;
    protected final List<javax.persistence.criteria.Order> orders = new ArrayList<javax.persistence.criteria.Order>();
    protected final List<javax.persistence.criteria.Predicate> predicates = new ArrayList<javax.persistence.criteria.Predicate>();
    protected CriteriaBuilder builder;
    protected Joinner joinner;

    @Deprecated
    public Repository() {
        this(null);
    }

    @Inject
    public Repository(@NotNull EntityManager em) {
        this.em = em;
    }

    @Transactional
    public <T> T save(@NotNull T entity) {
        T e = this.saveWithoutTransaction(entity);
        this.flush();
        return e;
    }

    @Transactional
    public <T> T merge(@NotNull T entity) {
        T e = this.mergeWithoutTransaction(entity);
        this.flush();
        return e;
    }

    @Transactional
    public <T> void persist(@NotNull T entity) {
        this.persistWithoutTransaction(entity);
        this.flush();
    }

    public <T> T mergeWithoutTransaction(@NotNull T entity) {
        entity = this.em.merge(entity);
        return entity;
    }

    public <T> void persistWithoutTransaction(@NotNull T entity) {
        this.em.persist(entity);
    }

    public <T> void refresh(@NotNull T entity) {
        this.em.refresh(entity);
    }

    public <T> T saveWithoutTransaction(@NotNull T entity) {
        if (!this.em.contains(entity) && this.isManaged(entity).booleanValue()) {
            entity = this.mergeWithoutTransaction(entity);
        } else {
            this.persistWithoutTransaction(entity);
        }
        return entity;
    }

    @Transactional
    public <T> void remove(@NotNull T entity) {
        this.removeWithoutTransaction(entity);
        this.flush();
    }

    public <T, Y> void remove(@NotNull Class<T> klass, @NotNull Y id) {
        T entity = this.byId(klass, id);
        this.remove(entity);
    }

    @Transactional
    public <T> void remove(@NotNull Collection<T> entities) {
        this.removeWithoutTransaction((T)entities);
        this.flush();
    }

    public <T> void removeWithoutTransaction(@NotNull Collection<T> entities) {
        for (T entity : entities) {
            this.removeWithoutTransaction(entity);
        }
    }

    public <T> void removeWithoutTransaction(@NotNull T entity) {
        this.em.remove(entity);
    }

    @Transactional
    public <T> void remove(@NotNull Class<T> type, @NotNull Long id) {
        Object entity = this.em.find(type, (Object)id);
        this.em.remove(entity);
        this.flush();
    }

    public <T, Y> T byId(@NotNull Class<T> klass, @NotNull Y id) throws NoResultException {
        this.from(klass);
        Attribute<T, ?> attribute = this.idAttribute(klass);
        T result = this.where(id, attribute).single();
        return result;
    }

    public <T> Repository from(@NotNull Class<T> type) {
        this.builder = this.em.getCriteriaBuilder();
        this.criteriaQuery = this.builder.createQuery(type);
        this.from = this.root(type);
        this.selection = this.from;
        this.joinner = new Joinner(this.builder, (From<?, ?>)this.from);
        return this;
    }

    public <T> Root<T> root(@NotNull Class<T> type) {
        return this.criteriaQuery.from(type);
    }

    public <T> Repository distinct(@NotNull Class<T> type) {
        this.from(type);
        return this.distinct();
    }

    public Repository distinct() {
        this.criteriaQuery.distinct(Boolean.TRUE.booleanValue());
        return this;
    }

    public <T> T single() {
        TypedQuery<T> query = this.query((Selection<?>)this.selection, this.criteriaQuery, this.predicates);
        this.filtersClears();
        return (T)query.getSingleResult();
    }

    public <T> PaginatedList<T, Meta> list(@NotNull @Min(value=0L) Integer page, @NotNull @Min(value=0L) Integer perPage) {
        TypedQuery<T> query = this.query((Selection<?>)this.selection, this.criteriaQuery, this.predicates);
        if (page != 0 && perPage != 0) {
            query.setMaxResults(perPage.intValue());
            query.setFirstResult((page - 1) * perPage);
        } else if (perPage != 0) {
            query.setMaxResults(perPage.intValue());
        }
        Long total = this.count();
        Meta meta = new Meta(total, Long.valueOf(page.intValue()));
        return new PaginatedMetaList((Collection)query.getResultList(), meta);
    }

    public Long count() {
        return this.count(Boolean.TRUE);
    }

    public Long count(Boolean distinct) {
        Set fetches = this.from.getFetches();
        Expression<?> from = this.selection;
        this.fetchToJoin((From<?, ?>)this.from, fetches);
        Expression s = distinct != false ? this.builder.countDistinct(from) : this.builder.count(from);
        this.ordersClear();
        TypedQuery query = this.query((Selection<?>)s, this.criteriaQuery, this.predicates);
        Long count = (Long)query.getResultList().get(0);
        this.filtersClears();
        return count;
    }

    public <T> T first() {
        List<T> list = this.list();
        if (list.isEmpty()) {
            throw new NoResultException();
        }
        return list.get(0);
    }

    public <T> T last() {
        List<T> list = this.list();
        if (list.isEmpty()) {
            throw new NoResultException();
        }
        return list.get(list.size() - 1);
    }

    public <T> Collection<T> collection() {
        return this.list();
    }

    public <T> PaginatedCollection<T, Meta> collection(@NotNull @Min(value=0L) Integer page, @NotNull @Min(value=0L) Integer perPage) {
        return this.list(page, perPage);
    }

    public <T> List<T> list() {
        TypedQuery<T> query = this.query((Selection<?>)this.selection, this.criteriaQuery, this.predicates);
        this.filtersClears();
        return query.getResultList();
    }

    public Repository where(@NotNull Predicate predicate) {
        return this.where(Arrays.asList(predicate));
    }

    public Repository or(@NotNull Predicate predicate) {
        javax.persistence.criteria.Predicate[] array = new javax.persistence.criteria.Predicate[this.predicates.size()];
        javax.persistence.criteria.Predicate p = this.builder.and(this.predicates.toArray(array));
        this.predicatesClear();
        this.predicates.add(this.builder.or((Expression)p, (Expression)this.to(predicate)));
        return this;
    }

    public <T> Repository or(@NotNull T value, Attribute<?, ?> ... attributes) {
        return this.or(value, Comparators.EQUAL, attributes);
    }

    public <T> Repository or(@NotNull T value, @NotNull Comparator comparator, Attribute<?, ?> ... attributes) {
        return this.or(new Predicate(value, comparator, attributes));
    }

    public Repository and(@NotNull Predicate predicate) {
        this.concat(this.to(predicate));
        return this;
    }

    public <T> Repository and(@NotNull T value, Attribute<?, ?> ... attributes) {
        return this.and(value, Comparators.EQUAL, attributes);
    }

    public <T> Repository and(@NotNull T value, @NotNull Comparator comparator, Attribute<?, ?> ... attributes) {
        return this.and(new Predicate(value, comparator, attributes));
    }

    public Repository orderBy(@NotNull Order.Direction direction, Attribute<?, ?> ... attributes) {
        Expression path = this.joinner.join(JoinType.INNER, attributes);
        javax.persistence.criteria.Order order = Order.Direction.ASC.equals((Object)direction) ? this.builder.asc(path) : this.builder.desc(path);
        this.orders.add(order);
        return this;
    }

    public Repository orderBy(@NotNull Order.Direction direction, @Size(min=1) @NotNull List<Attribute<?, ?>> attributes) {
        this.orderBy(direction, attributes.toArray(new Attribute[attributes.size()]));
        return this;
    }

    public Repository orderBy(Order ... orders) {
        this.orderBy(Arrays.asList(orders));
        return this;
    }

    public Repository orderBy(@NotNull List<Order> orders) {
        for (Order order : orders) {
            this.orderBy(order.getDirection(), order.getAttributes());
        }
        return this;
    }

    public <T> Repository where(@NotNull T value, Attribute<?, ?> ... attributes) {
        return this.where(Arrays.asList(new Predicate(value, attributes)));
    }

    public <T> Repository where(@NotNull T value, @NotNull Comparator comparator, Attribute<?, ?> ... attributes) {
        return this.where(Arrays.asList(new Predicate(value, comparator, attributes)));
    }

    public <T> Repository fetch(JoinType type, Attribute<?, ?> ... attributes) {
        Fetch fetch = this.from;
        for (Attribute<?, ?> attribute : attributes) {
            fetch = fetch.fetch(attribute.getName(), type);
        }
        return this;
    }

    public <T> Repository fetch(Attribute<?, ?> ... attributes) {
        this.fetch(JoinType.INNER, attributes);
        return this;
    }

    public <T> Repository select(Attribute<?, ?> ... attributes) {
        this.select(JoinType.INNER, attributes);
        return this;
    }

    public <T> Repository select(JoinType joinType, Attribute<?, ?> ... attributes) {
        if (attributes.length > 0) {
            this.selection = this.joinner.select(JoinType.INNER, attributes);
        }
        return this;
    }

    public <T> Repository where(@NotNull Comparator comparator, Attribute<?, ?> ... attributes) {
        return this.where(Arrays.asList(new Predicate(comparator, attributes)));
    }

    public Repository where(@NotNull Collection<Predicate> predicates) {
        if (!predicates.isEmpty()) {
            this.to(predicates);
        }
        return this;
    }

    public Boolean exist() {
        try {
            return this.count() > 0L;
        }
        catch (NoResultException e) {
            return Boolean.FALSE;
        }
    }

    public Boolean notExist() {
        return this.exist() == false;
    }

    public Repository hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    public void change(@NotNull EntityManager em) {
        em.getEntityManagerFactory().getProperties().get("name");
        this.em = em;
    }

    @Transactional
    public <T> void remove() {
        this.removeWithoutTransaction();
        this.flush();
    }

    public <T> void removeWithoutTransaction() {
        Collection<T> entities = this.collection();
        this.removeWithoutTransaction((T)entities);
    }

    @Transactional
    public <T> void save(@NotNull Collection<T> entities) {
        this.saveWithoutTransaction(entities);
        this.flush();
    }

    public <T> void saveWithoutTransaction(@NotNull Collection<T> entities) {
        for (T entity : entities) {
            this.saveWithoutTransaction(entity);
        }
    }

    public void close() {
        this.em.close();
    }

    public Repository clear() {
        this.em.clear();
        return this;
    }

    public Repository readonly() {
        this.hint("org.hibernate.readOnly", "true");
        this.hint("org.hibernate.cacheable", "false");
        this.hint("eclipselink.read-only", "true");
        this.hint("eclipselink.query-results-cache", "true");
        return this;
    }

    protected void hintsClear() {
        this.hints.clear();
    }

    protected void ordersClear() {
        this.orders.clear();
    }

    protected void predicatesClear() {
        this.predicates.clear();
    }

    protected void filtersClears() {
        this.hintsClear();
        this.ordersClear();
        this.predicatesClear();
    }

    protected <T> Boolean isManaged(T record) {
        return this.idValue(record) != null;
    }

    protected <X> Attribute<? super X, ?> idAttribute(Class<X> klazz) {
        EntityType type = this.em.getMetamodel().entity(klazz);
        Class idType = type.getIdType().getJavaType();
        SingularAttribute attribute = type.getId(idType);
        return attribute;
    }

    protected <T> Object idValue(T record) {
        Class<?> type = record.getClass();
        String name = this.idName(type);
        try {
            Field field = this.getField(type, name);
            field.setAccessible(Boolean.TRUE);
            Object value = field.get(record);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected Field getField(Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(Boolean.TRUE);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (type.equals(Object.class)) {
                throw new RuntimeException(e);
            }
            return this.getField(type.getSuperclass(), name);
        }
    }

    protected String idName(Class<?> klazz) {
        Attribute<?, ?> id = this.idAttribute(klazz);
        String field = id.getName();
        return field;
    }

    protected void flush() {
        logger.info("Executando Flush no Banco de dados");
        try {
            this.em.joinTransaction();
        }
        catch (TransactionRequiredException e) {
            // empty catch block
        }
        try {
            this.em.flush();
        }
        catch (TransactionRequiredException e) {
            logger.warning("N\u00e3o h\u00e1 transa\u00e7\u00e3o em andamento para rodar o EntityManager#flush");
            throw e;
        }
    }

    protected <T> TypedQuery<T> query(Selection<?> selection, CriteriaQuery<?> criteriaQuery, List<javax.persistence.criteria.Predicate> predicates) {
        CriteriaQuery<?> cq = criteriaQuery;
        Selection<?> s = selection;
        cq.select(s);
        criteriaQuery.orderBy(this.orders.toArray(new javax.persistence.criteria.Order[0]));
        javax.persistence.criteria.Predicate[] array = new javax.persistence.criteria.Predicate[predicates.size()];
        cq.where(predicates.toArray(array));
        TypedQuery query = this.em.createQuery(cq);
        for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            query.setHint(key, value);
        }
        return query;
    }

    protected void to(@NotNull @Size(min=1) Collection<Predicate> predicates) {
        int j = predicates.size() - 1;
        ArrayList<Predicate> ps = new ArrayList<Predicate>(predicates);
        javax.persistence.criteria.Predicate p = this.to((Predicate)ps.get(0));
        for (int i = 1; i <= j; ++i) {
            javax.persistence.criteria.Predicate other = this.to((Predicate)ps.get(i));
            Operator operator = ((Predicate)ps.get(i)).getOperator();
            p = operator.build(this.builder, (Expression<Boolean>)p, (Expression<Boolean>)other);
        }
        this.concat(p);
    }

    protected javax.persistence.criteria.Predicate to(@NotNull Predicate predicate) {
        return this.joinner.join(predicate);
    }

    protected void concat(javax.persistence.criteria.Predicate ... predicates) {
        javax.persistence.criteria.Predicate and = this.builder.and(predicates);
        this.predicates.add(and);
    }

    protected void fetchToJoin(From<?, ?> from, Set<Fetch<?, ?>> fetches) {
        if (fetches != null && !fetches.isEmpty()) {
            for (Fetch<?, ?> fetch : fetches) {
                Join join = (Join)fetch;
                Set fs = fetch.getFetches();
                if (fs.isEmpty()) {
                    try {
                        from.getJoins().add(join);
                    }
                    catch (UnsupportedOperationException e) {}
                    continue;
                }
                this.fetchToJoin((From<?, ?>)join, fs);
            }
            from.getFetches().clear();
        }
    }
}

