/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository.http;

import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Comparators;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Record {
    private static final Logger logger = Logger.getLogger(Record.class.getSimpleName());
    public static final Pattern escaper = Pattern.compile("([^a-zA-z0-9])");
    public final Object value;
    public final Comparator comparator;

    public Record(Object value, Comparator comparator) {
        this.value = value;
        this.comparator = comparator;
    }

    public static Record valueOf(String[] values) {
        if (values.length == 1) {
            return Record.valueOf(values[0]);
        }
        return new Record(values, (Comparator)Comparators.EQUAL);
    }

    public static Record valueOf(String value) {
        for (Comparators comparator : Comparators.values()) {
            String expression = escaper.matcher(comparator.toString()).replaceAll("\\\\$1").replace("^", "\\^");
            String regex = "^" + expression + ".*";
            logger.log(Level.FINE, regex);
            if (!value.matches(regex)) continue;
            return new Record(value.replaceAll(expression, ""), (Comparator)comparator);
        }
        return new Record(value, (Comparator)Comparators.EQUAL);
    }
}

