/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.migrator;

import br.eti.clairton.migrator.Config;
import br.eti.clairton.migrator.Inserter;
import br.eti.clairton.migrator.Migrator;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

@Dependent
public class MigratorDefault
implements Migrator {
    private static final Logger logger = Logger.getLogger(MigratorDefault.class.getSimpleName());
    private final Config config;
    private final Inserter inserter;
    private final Liquibase liquibase;

    @Deprecated
    protected MigratorDefault() {
        this((Liquibase)null, null, null);
    }

    @Deprecated
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config) {
        this(connection, config, new Inserter(), MigratorDefault.class.getClassLoader());
    }

    @Inject
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config, @NotNull Inserter inserter) {
        this(connection, config, inserter, MigratorDefault.class.getClassLoader());
    }

    @Deprecated
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config, @NotNull ClassLoader classLoader) {
        this(connection, config, new Inserter(), classLoader);
    }

    public MigratorDefault(Connection connection, Config config, Inserter inserter, ClassLoader classLoader) {
        this(MigratorDefault.getLiquibase(classLoader, connection, config.getChangelogPath()), config, inserter);
    }

    public MigratorDefault(Liquibase liquibase, Config config, Inserter inserter) {
        this.liquibase = liquibase;
        this.config = config;
        this.inserter = inserter;
    }

    @Override
    public void run() {
        DatabaseConnection connection = this.liquibase.getDatabase().getConnection();
        try {
            if (!this.config.isMigrate().booleanValue()) {
                logger.log(Level.INFO, "N\u00e3o ir\u00e1 rodar as migra\u00e7\u00f5es");
                return;
            }
            if (this.config.getSchema() != null && !this.config.getSchema().isEmpty()) {
                logger.log(Level.INFO, "Setando o esquema padr\u00e3o para {0}", this.config.getSchema());
                Database database = this.liquibase.getDatabase();
                database.setDefaultSchemaName(this.config.getSchema());
            } else {
                logger.log(Level.INFO, "N\u00e3o foi setado o esquema padr\u00e3o");
            }
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(Boolean.FALSE.booleanValue());
            try {
                if (this.config.getSchema() != null && !this.config.getSchema().isEmpty()) {
                    connection.nativeSQL(String.format("CREATE SCHEMA %s;", this.config.getSchema()));
                }
            }
            catch (Exception e) {
                try {
                    connection.rollback();
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            if (this.config.isDrop().booleanValue()) {
                this.turnoff(connection);
                logger.log(Level.INFO, "Deletando objetos");
                if (this.config.getSchema() != null && !this.config.getSchema().isEmpty()) {
                    CatalogAndSchema schemas = new CatalogAndSchema(null, this.config.getSchema());
                    this.liquibase.dropAll(new CatalogAndSchema[]{schemas});
                } else {
                    this.liquibase.dropAll();
                }
            }
            String context = "";
            logger.log(Level.INFO, "Rodando changesets {0}", this.config.getChangelogPath());
            this.liquibase.update("");
            logger.log(Level.INFO, "Changesets {0} aplicados com sucesso", this.config.getChangelogPath());
            ClassLoader classLoader = this.liquibase.getResourceAccessor().toClassLoader();
            this.inserter.run(((JdbcConnection)connection).getWrappedConnection(), this.config, classLoader);
            connection.commit();
            connection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.turnoff(connection);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void turnoff(DatabaseConnection connection) {
        try {
            connection.rollback();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        try {
            logger.log(Level.INFO, "Desligando dataBase changelock");
            String command = "UPDATE databasechangeloglock SET locked=false";
            connection.nativeSQL("UPDATE databasechangeloglock SET locked=false");
            connection.commit();
            logger.log(Level.INFO, "DataBase change lock desligado");
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                connection.setAutoCommit(Boolean.FALSE.booleanValue());
            }
            catch (Exception exception) {}
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public Inserter getInserter() {
        return this.inserter;
    }

    public Liquibase getLiquibase() {
        return this.liquibase;
    }

    private static Liquibase getLiquibase(ClassLoader classLoader, Connection connection, String changelogPath) {
        try {
            JdbcConnection jdbcConnection = new JdbcConnection(connection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classLoader);
            Liquibase liquibase = new Liquibase(changelogPath, (ResourceAccessor)resourceAccessor, database);
            return liquibase;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

