/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.migrator;

import br.eti.clairton.migrator.Config;
import br.eti.clairton.migrator.Inserter;
import br.eti.clairton.migrator.Migrator;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

@Dependent
public class MigratorDefault
implements Migrator {
    private static final Logger logger = Logger.getLogger(MigratorDefault.class.getSimpleName());
    private final Connection connection;
    private final Config config;
    private final ClassLoader classLoader;
    private final Inserter inserter;

    @Deprecated
    protected MigratorDefault() {
        this(null, null, null, null);
    }

    @Deprecated
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config) {
        this(connection, config, new Inserter(), MigratorDefault.class.getClassLoader());
    }

    @Inject
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config, Inserter inserter) {
        this(connection, config, inserter, MigratorDefault.class.getClassLoader());
    }

    @Deprecated
    public MigratorDefault(@NotNull Connection connection, @NotNull Config config, @NotNull ClassLoader classLoader) {
        this(connection, config, new Inserter(), classLoader);
    }

    public MigratorDefault(@NotNull Connection connection, @NotNull Config config, Inserter inserter, @NotNull ClassLoader classLoader) {
        this.connection = connection;
        this.config = config;
        this.classLoader = classLoader;
        this.inserter = inserter;
    }

    @Override
    public void run() {
        try {
            JdbcConnection jdbcConnection = new JdbcConnection(this.connection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
            if (this.config.getSchema() != null && !this.config.getSchema().isEmpty()) {
                logger.log(Level.INFO, "Setando o esquema padr\u00e3o para {0}", this.config.getSchema());
                database.setDefaultSchemaName(this.config.getSchema());
            } else {
                logger.log(Level.INFO, "N\u00e3o foi setado o esquema padr\u00e3o");
            }
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.classLoader);
            Liquibase liquibase = new Liquibase(this.config.getChangelogPath(), (ResourceAccessor)resourceAccessor, database);
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(Boolean.FALSE);
            try {
                this.connection.createStatement().executeQuery(String.format("CREATE SCHEMA %s;", this.config.getSchema()));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.config.isDrop().booleanValue()) {
                this.turnoff();
                logger.log(Level.INFO, "Deletando objetos");
                if (this.config.getSchema() != null && !this.config.getSchema().isEmpty()) {
                    CatalogAndSchema schemas = new CatalogAndSchema(null, this.config.getSchema());
                    liquibase.dropAll(new CatalogAndSchema[]{schemas});
                } else {
                    liquibase.dropAll();
                }
            }
            String context = "";
            logger.log(Level.INFO, "Rodando changesets {0}", this.config.getChangelogPath());
            liquibase.update("");
            logger.log(Level.INFO, "Changesets {0} aplicados com sucesso", this.config.getChangelogPath());
            this.inserter.run(this.connection, this.config, this.classLoader);
            this.connection.commit();
            this.connection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            this.turnoff();
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void turnoff() {
        try {
            logger.log(Level.INFO, "Desligando dataBase changelock");
            String command = "UPDATE databasechangeloglock SET locked=false";
            this.connection.createStatement().executeUpdate("UPDATE databasechangeloglock SET locked=false");
            this.connection.commit();
            logger.log(Level.INFO, "DataBase change lock desligado");
        }
        catch (Exception e) {
            try {
                this.connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                this.connection.setAutoCommit(Boolean.FALSE);
            }
            catch (Exception exception) {}
        }
    }
}

