/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.migrator;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.datatype.DataType;

public class CsvDataSet
extends CachedDataSet
implements IDataSet {
    public CsvDataSet(URL file) throws DataSetException {
        this.produceFromFile(file);
    }

    private void produceFromFile(URL file) throws DataSetException, CsvParserException {
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(file);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            for (int i = 0; i < readColumns.size(); ++i) {
                String columnName = ((String)readColumns.get(i)).trim();
                columns[i] = new Column(columnName, DataType.UNKNOWN);
            }
            String fileName = new File(file.getFile()).getName();
            Integer endIndex = fileName.indexOf(".csv");
            String tableName = fileName.substring(0, endIndex);
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this.startTable((ITableMetaData)metaData);
            for (int i = 1; i < readData.size(); ++i) {
                List rowList = (List)readData.get(i);
                Object[] row = rowList.toArray();
                for (int col = 0; col < row.length; ++col) {
                    row[col] = row[col].equals("null") ? null : row[col];
                }
                this.row(row);
            }
            this.endTable();
        }
        catch (Exception e) {
            throw new DataSetException((Throwable)e);
        }
    }
}

