/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.migrator;

import br.eti.clairton.migrator.Config;
import br.eti.clairton.migrator.CsvDataSet;
import br.eti.clairton.migrator.DataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;

@Dependent
public class Inserter {
    private static final Logger logger = Logger.getLogger(Inserter.class.getSimpleName());

    public void run(Connection connection, Config config, ClassLoader classLoader) throws Exception {
        if (config.isPopulate().booleanValue()) {
            logger.log(Level.INFO, "Carregando dataSets em {}", config.getDataSetPath());
            ArrayList<URL> files = new ArrayList<URL>();
            String path = config.getDataSetPath();
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources != null && resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String scheme = url.toURI().getScheme();
                if ("vfs".equals(scheme)) {
                    InputStream inputStream = url.openStream();
                    if (!(inputStream instanceof JarInputStream)) continue;
                    JarInputStream jarStream = (JarInputStream)inputStream;
                    files.addAll(this.loadJar(jarStream, classLoader, path));
                    continue;
                }
                if ("jar".equals(scheme)) {
                    logger.log(Level.INFO, "Jar " + url.getPath());
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    Enumeration<JarEntry> en = conn.getJarFile().entries();
                    String mainEntryName = conn.getEntryName();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(mainEntryName) || !entryName.endsWith(".csv")) continue;
                        String name = url.toURI() + entryName.replace(mainEntryName, "");
                        logger.log(Level.FINE, "Adicionando arquivo csv {}", name);
                        URL u = new URL(name);
                        files.add(u);
                    }
                    continue;
                }
                File file = new File(url.getPath());
                logger.log(Level.INFO, "Diret\u00f3rio " + file);
                this.listFilesForFolder(file, files);
            }
            this.load(files.toArray(new URL[files.size()]), connection, config.getSchema());
        }
    }

    public List<URL> loadJar(JarInputStream jarStream, ClassLoader classLoader, String path) throws IOException {
        JarEntry entry;
        ArrayList<URL> files = new ArrayList<URL>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (!entry.toString().endsWith(".csv")) continue;
            URL file = classLoader.getResource(path + "/" + entry);
            logger.log(Level.FINE, "Adicionando arquivo csv {}", file);
            files.add(file);
        }
        return files;
    }

    private void listFilesForFolder(File file, Collection<URL> files) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.listFilesForFolder(f, files);
            }
        } else if (file.toString().endsWith(".csv")) {
            logger.log(Level.FINE, "Adicionando arquivo csv " + file);
            try {
                files.add(new File(file.toString()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void load(DataSet annotation, Connection connection, String schema) throws Exception {
        List<String> files = Arrays.asList(annotation.value());
        logger.log(Level.INFO, "Datasets a inserir {}", files);
        Annotation qualifier = this.getQualifier(annotation.qualifier());
        logger.log(Level.INFO, "Recuperando conex\u00e3o com qualifier {}", qualifier.annotationType().getSimpleName());
        logger.log(Level.INFO, "Conex\u00e3o recuperada " + connection);
        this.load(files, connection, schema);
    }

    public void load(Collection<String> files, Connection connection, String schema) throws Exception {
        ArrayList<URL> csvs = new ArrayList<URL>(files.size());
        for (String path : files) {
            ClassLoader cl = this.getClass().getClassLoader();
            Enumeration<URL> resources = cl.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                csvs.add(url);
            }
        }
        this.load(csvs.toArray(new URL[csvs.size()]), connection, schema);
    }

    public void load(URL[] files, Connection connection, String schema) throws Exception {
        ArrayList<ReplacementDataSet> dataSets = new ArrayList<ReplacementDataSet>(files.length);
        for (URL file : files) {
            if (!file.toString().endsWith(".csv")) {
                throw new IllegalStateException("Only supports CSV and SQL data sets for the moment");
            }
            logger.log(Level.INFO, "Adicionando dataset {}", file.toString());
            ReplacementDataSet rDataSet = new ReplacementDataSet((IDataSet)new CsvDataSet(file));
            String content = Inserter.getString(file.openStream());
            String s = "\\$\\{sql\\(";
            String e = "\\)\\}";
            Pattern pattern = Pattern.compile("\\$\\{sql\\(.*\\)\\}");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                int begin = matcher.start();
                int end = matcher.end();
                String key = content.substring(begin, end);
                String sql = key.replaceAll("\\$\\{sql\\(", "").replaceAll("\\)\\}", "");
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                resultSet.next();
                String value = resultSet.getString(1);
                rDataSet.addReplacementObject((Object)key, (Object)value);
            }
            dataSets.add(rDataSet);
        }
        IDataSet[] a = new IDataSet[dataSets.size()];
        CompositeDataSet dataSet = new CompositeDataSet(dataSets.toArray(a));
        DatabaseConnection ddsc = new DatabaseConnection(connection);
        DatabaseSequenceFilter filter = new DatabaseSequenceFilter((IDatabaseConnection)ddsc);
        FilteredDataSet fDataSet = new FilteredDataSet((ITableFilter)filter, (IDataSet)dataSet);
        this.load((IDataSet)fDataSet, connection, schema);
    }

    public void load(String path, Connection connection, String schema) throws Exception {
        org.dbunit.dataset.csv.CsvDataSet dataSet = new org.dbunit.dataset.csv.CsvDataSet(new File(path));
        logger.log(Level.INFO, "Inserindo datasets: ");
        for (String table : dataSet.getTableNames()) {
            logger.log(Level.FINE, "     " + table);
        }
        this.load((IDataSet)dataSet, connection, schema);
    }

    public void load(IDataSet dataSet, Connection connection, String schema) throws Exception {
        DatabaseConnection ddsc = new DatabaseConnection(connection, schema);
        HsqldbDataTypeFactory factory = new HsqldbDataTypeFactory();
        ddsc.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)factory);
        this.insert(dataSet, (IDatabaseConnection)ddsc);
    }

    public void insert(IDataSet dataSet, IDatabaseConnection connection) throws Exception {
        DatabaseOperation.INSERT.execute(connection, dataSet);
    }

    private <T extends Annotation> Annotation getQualifier(final Class<T> type) {
        return new Inject(){

            public Class<? extends Annotation> annotationType() {
                return type;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getString(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

