/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.jpa.serializer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Tagable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String getRootTag(T src) {
        Class<?> type = src.getClass();
        String name = type.getSimpleName();
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getRootTagCollection(Collection<T> collection) {
        T src = this.getFirst(collection);
        String tag = this.getRootTag(src);
        String collectionTag = this.pluralize(tag);
        return collectionTag;
    }

    public String pluralize(String tag) {
        return String.format("%s%s", tag, "s");
    }

    protected T getFirst(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        T src = iterator.next();
        return src;
    }
}

