/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.jpa.serializer;

import br.eti.clairton.jpa.serializer.Mode;
import br.eti.clairton.jpa.serializer.Nodes;
import br.eti.clairton.jpa.serializer.NodesProgramatic;
import br.eti.clairton.jpa.serializer.Operation;
import br.eti.clairton.jpa.serializer.Tagable;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import net.vidageek.mirror.dsl.AccessorsController;
import net.vidageek.mirror.dsl.ClassController;
import net.vidageek.mirror.dsl.Mirror;

public abstract class JpaSerializer<T>
extends Tagable<T> {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(JpaSerializer.class.getSimpleName());
    private final Nodes nodes;
    protected final Mirror mirror = new Mirror();

    public JpaSerializer() {
        this(new NodesProgramatic());
    }

    public JpaSerializer(Nodes nodes) {
        this.nodes = nodes;
    }

    protected void record(String field) {
        this.config(field, Mode.RECORD);
    }

    protected void record(String field, Operation operation) {
        this.config(field, Mode.RECORD, operation);
    }

    protected void id(String field) {
        this.config(field, Mode.ID);
    }

    protected void idPolymorphic(String field) {
        this.config(field, Mode.ID_POLYMORPHIC);
    }

    protected void id(String field, Operation operation) {
        this.config(field, Mode.ID, operation);
    }

    protected void idPolymorphic(String field, Operation operation) {
        this.config(field, Mode.ID_POLYMORPHIC, operation);
    }

    protected void reload(String field) {
        this.config(field, Mode.RELOAD);
    }

    protected void reload(String field, Operation operation) {
        this.config(field, Mode.RELOAD, operation);
    }

    protected void ignore(String field) {
        this.config(field, Mode.IGNORE);
    }

    protected void ignore(String field, Operation operation) {
        this.config(field, Mode.IGNORE, operation);
    }

    protected void config(String field, Mode mode) {
        this.nodes().put(field, mode);
    }

    protected void config(String field, Mode mode, Operation operation) {
        this.nodes().put(field, mode, operation);
    }

    protected Field getField(Class<?> type, String field) {
        ClassController controller = this.mirror.on(type);
        return controller.reflect().field(field);
    }

    protected Object getId(Object target) {
        return this.getValue(target, "id");
    }

    protected Object getValue(Object target, String field) {
        AccessorsController controller = this.mirror.on(target);
        return controller.get().field(field);
    }

    protected Object getValue(Object target, Field field) {
        AccessorsController controller = this.mirror.on(target);
        return controller.get().field(field);
    }

    protected void setValue(Object target, Field field, Object value) {
        AccessorsController accessor = this.mirror.on(target);
        accessor.set().field(field).withValue(value);
    }

    protected Class<T> getClass(Type type) {
        String name = type.toString().replaceAll("class ", "").replaceAll("<\\?.*", "");
        try {
            Class<?> t = Class.forName(name);
            this.logger.log(Level.FINE, "Deserializando tipo {}", t.getSimpleName());
            return t;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro ao instanciar tipo {}, detalhe: {}", new Object[]{type, e.getMessage()});
            this.logger.log(Level.FINE, "Erro ao instanciar", e);
            throw new JsonParseException((Throwable)e);
        }
    }

    public Nodes nodes() {
        return this.nodes;
    }

    @Deprecated
    protected Boolean isToMany(Field field, Operation operation) {
        return this.isToMany(null, field, operation);
    }

    @Deprecated
    protected Boolean isToOne(Field field, Operation operation) {
        return this.isToOne(null, field, operation);
    }

    @Deprecated
    protected Boolean isIgnore(String key, Operation operation) {
        return this.isIgnore(null, key, operation);
    }

    @Deprecated
    protected Boolean isIgnore(String key) {
        return this.isIgnore(null, key);
    }

    @Deprecated
    protected Boolean isId(String key, Operation operation) {
        return this.isId(null, key, operation);
    }

    @Deprecated
    protected Boolean isId(String key) {
        return this.isId(null, key);
    }

    @Deprecated
    protected Boolean isIdPolymorphic(String key) {
        return this.isIdPolymorphic(null, key);
    }

    @Deprecated
    protected Boolean isIdPolymorphic(String key, Operation operation) {
        return this.isIdPolymorphic(null, key, operation);
    }

    @Deprecated
    protected Boolean isReload(String key, Operation operation) {
        return this.isReload(null, key, operation);
    }

    @Deprecated
    protected Boolean isReload(String key) {
        return this.isReload(null, key);
    }

    @Deprecated
    protected Boolean isRecord(String key, Operation operation) {
        return this.isRecord(null, key, operation);
    }

    @Deprecated
    protected Boolean isRecord(String key) {
        return this.isRecord(null, key);
    }

    protected Boolean isToMany(Object source, Field field, Operation operation) {
        return (field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(OneToOne.class)) && this.isRecord(source, field.getName(), operation) == false && this.isReload(source, field.getName(), operation) == false;
    }

    protected Boolean isToOne(Object source, Field field, Operation operation) {
        return (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) && this.isRecord(source, field.getName(), operation) == false && this.isReload(source, field.getName(), operation) == false;
    }

    protected Boolean isIgnore(Object source, String key, Operation operation) {
        return this.nodes(source).isIgnore(key, operation);
    }

    protected Boolean isIgnore(Object source, String key) {
        return this.nodes(source).isIgnore(key);
    }

    protected Boolean isId(Object source, String key, Operation operation) {
        return this.nodes(source).isId(key, operation);
    }

    protected Boolean isId(Object source, String key) {
        return this.nodes(source).isId(key);
    }

    protected Boolean isIdPolymorphic(Object source, String key) {
        return this.nodes(source).isIdPolymorphic(key);
    }

    protected Boolean isIdPolymorphic(Object source, String key, Operation operation) {
        return this.nodes(source).isIdPolymorphic(key, operation);
    }

    protected Boolean isReload(Object source, String key, Operation operation) {
        return this.nodes(source).isReload(key, operation);
    }

    protected Boolean isReload(Object source, String key) {
        return this.nodes(source).isReload(key);
    }

    protected Boolean isRecord(Object source, String key, Operation operation) {
        return this.nodes(source).isRecord(key, operation);
    }

    protected Boolean isRecord(Object source, String key) {
        return this.nodes(source).isRecord(key);
    }

    public Nodes nodes(Object source) {
        return this.nodes;
    }
}

