/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.jpa.serializer;

import br.eti.clairton.jpa.serializer.JpaSerializer;
import br.eti.clairton.jpa.serializer.Nodes;
import br.eti.clairton.jpa.serializer.Operation;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.validation.constraints.NotNull;
import net.vidageek.mirror.invoke.dsl.InvocationHandler;
import net.vidageek.mirror.set.dsl.FieldSetter;
import net.vidageek.mirror.set.dsl.SetterHandler;

public class GsonJpaSerializer<T>
extends JpaSerializer<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(GsonJpaSerializer.class.getSimpleName());
    private final EntityManager entityManager;
    private static final Map<Class<?>, Method> annotations = new HashMap<Class<?>, Method>(){
        private static final long serialVersionUID = 1L;
        {
            try {
                this.put(OneToMany.class, OneToMany.class.getMethod("mappedBy", new Class[0]));
                this.put(ManyToMany.class, ManyToMany.class.getMethod("mappedBy", new Class[0]));
                this.put(OneToOne.class, OneToOne.class.getMethod("mappedBy", new Class[0]));
            }
            catch (Exception e) {
                throw new NoSuchElementException();
            }
        }
    };

    public GsonJpaSerializer(Nodes nodes, EntityManager entityManager) {
        super(nodes);
        this.entityManager = entityManager;
    }

    public GsonJpaSerializer(@NotNull EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public JsonElement serialize(T src, Type type, JsonSerializationContext context) {
        try {
            JsonObject json = new JsonObject();
            Class klazz = this.getClass(type);
            List<Field> fields = this.getFields(klazz);
            for (Field field : fields) {
                String tag = this.getTag(field);
                if (this.isIgnore(src, tag, Operation.SERIALIZE).booleanValue()) {
                    this.logger.log(Level.FINE, "Ignorando field {}", tag);
                    continue;
                }
                JsonElement element = this.serialize(src, field, type, context);
                json.add(tag, element);
            }
            return json;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro ao serializar " + src, e);
            throw new JsonParseException((Throwable)e);
        }
    }

    public T deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        T model = this.getInstance(type);
        JsonObject jsonObject = (JsonObject)json;
        for (Map.Entry entry : jsonObject.entrySet()) {
            Field field = this.getField(model.getClass(), (String)entry.getKey());
            if (field == null) {
                this.logger.log(Level.WARNING, "Field {} n\u00e3o encontrado em {}", new Object[]{entry.getKey(), model.getClass().getSimpleName()});
                continue;
            }
            Object value = this.getValue(context, (JsonElement)entry.getValue(), model, field);
            this.logger.log(Level.FINE, "Valor extraido {}#{}={}", new Object[]{type, field.getName(), value});
            this.setValue(model, field, value);
        }
        return model;
    }

    protected JsonElement serialize(Object src, Field field, Type type, JsonSerializationContext context) {
        Object value = this.getValue(context, src, field);
        if (value == null) {
            return context.serialize(value);
        }
        return context.serialize(value, value.getClass());
    }

    protected List<Field> getFields(Class<T> klazz) {
        return this.mirror.on(klazz).reflectAll().fields();
    }

    protected String getTag(Field field) {
        return field.getName();
    }

    protected Object getValue(JsonSerializationContext context, Object src, Field field) {
        Object value;
        String klazz = src.getClass().getSimpleName();
        String tag = field.getName();
        this.logger.log(Level.FINE, "Serializando {}#{}", new Object[]{klazz, tag});
        if (this.isToOne(src, field, Operation.SERIALIZE).booleanValue()) {
            ArrayList<Object> ids = new ArrayList<Object>();
            Object v = this.getValue(src, field);
            Collection models = (Collection)Collection.class.cast(v);
            if (this.isIdPolymorphic(src, field.getName(), Operation.SERIALIZE).booleanValue()) {
                for (Object model : models) {
                    HashMap<String, Object> object = new HashMap<String, Object>();
                    object.put(this.getPolymorphicTagName(model), this.getPolymorphicTagValue(model));
                    object.put("id", this.getId(model));
                    ids.add(object);
                }
            } else {
                for (Object model : models) {
                    ids.add(this.getId(model));
                }
            }
            value = ids;
        } else {
            Object v;
            value = this.isToMany(src, field, Operation.SERIALIZE).booleanValue() ? ((v = this.getValue(src, field)) == null ? null : this.getId(v)) : this.getValue(src, field);
        }
        this.logger.log(Level.FINE, "Valor extraido {}#{}={}", new Object[]{klazz, tag, value});
        return value;
    }

    protected T getInstance(Type type) {
        Class klazz = this.getClass(type);
        InvocationHandler invoke = this.mirror.on(klazz).invoke();
        return klazz.cast(invoke.constructor().withoutArgs());
    }

    protected Object getValue(JsonDeserializationContext context, JsonElement element, Object target, Field field) {
        Object value = field == null ? null : (this.isToOne(target, field, Operation.DESERIALIZE) != false ? this.toMany(context, field, element) : (this.isToMany(target, field, Operation.DESERIALIZE) != false ? this.toOne(context, field, element) : (JsonArray.class.isInstance(element) ? this.getValueCollection(context, element.getAsJsonArray(), target, field) : this.getValue(context, field.getName(), field.getType(), element))));
        return value;
    }

    protected <W> W getValue(JsonDeserializationContext context, String field, Class<?> type, JsonElement element) {
        Object value;
        if (JsonNull.class.isInstance(element)) {
            value = null;
        } else if (this.isReload(null, field, Operation.DESERIALIZE).booleanValue()) {
            Object w = this.entityManager.find(type, this.unwrapId(type, element));
            value = w;
            if (value == null) {
                throw new EntityNotFoundException();
            }
        } else {
            value = context.deserialize(element, type);
        }
        return (W)value;
    }

    protected Object unwrapId(Class<?> type, JsonElement element) {
        if (JsonNull.class.isInstance(element)) {
            return null;
        }
        Metamodel metamodel = this.entityManager.getMetamodel();
        EntityType entity = metamodel.entity(type);
        javax.persistence.metamodel.Type entityType = entity.getIdType();
        Class idType = entityType.getJavaType();
        if (Long.class.equals((Object)idType)) {
            return element.getAsLong();
        }
        if (Integer.class.equals((Object)idType)) {
            return element.getAsInt();
        }
        return element.getAsString();
    }

    protected <X extends Annotation> String getMappedBy(Field field) {
        for (Map.Entry<Class<?>, Method> entry : annotations.entrySet()) {
            Class<?> type = entry.getKey();
            Object x = field.getAnnotation(type);
            if (x == null) continue;
            Method mappedBy = entry.getValue();
            try {
                return (String)mappedBy.invoke(x, new Object[0]);
            }
            catch (Exception e) {
                throw new NoSuchElementException();
            }
        }
        return null;
    }

    protected Class<?> getRawType(Field field) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Type[] arguments = parameterizedType.getActualTypeArguments();
        return this.getClass(arguments[0]);
    }

    protected <W> Collection<W> getValueCollection(JsonDeserializationContext context, JsonArray array, Object target, Field field) {
        Collection collection = (Collection)this.getInstance(field.getType());
        Class<?> type = this.getRawType(field);
        String mappedBy = this.getMappedBy(field);
        for (JsonElement a : array) {
            W object = this.getValue(context, field.getName(), type, a);
            collection.add(object);
        }
        if (mappedBy != null && !mappedBy.isEmpty()) {
            for (Object object : collection) {
                this.mirror.on(object).set().field(mappedBy).withValue(target);
            }
        }
        return collection;
    }

    protected <W> W toOne(JsonDeserializationContext context, Field field, JsonElement element) {
        Object value;
        if (JsonNull.class.isInstance(element)) {
            return null;
        }
        Metamodel metamodel = this.entityManager.getMetamodel();
        EntityType entity = metamodel.entity(field.getType());
        javax.persistence.metamodel.Type entityType = entity.getIdType();
        Class idType = entityType.getJavaType();
        try {
            Object v;
            value = v = this.newInstance(field.getType());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SingularAttribute attribute = entity.getId(idType);
        String fieldIdName = attribute.getName();
        SetterHandler handler = this.mirror.on(value).set();
        FieldSetter fieldSetter = handler.field(fieldIdName);
        fieldSetter.withValue((Object)element.getAsLong());
        return (W)value;
    }

    protected <X> X newInstance(Class<X> klazz) {
        try {
            return klazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <W> Collection<W> toMany(JsonDeserializationContext context, Field field, JsonElement element) {
        Type fielType = field.getGenericType();
        ParameterizedType pType = (ParameterizedType)fielType;
        Type[] arr = pType.getActualTypeArguments();
        Class elementType = this.getClass(arr[0]);
        Collection collection = (Collection)this.getInstance(field.getType());
        JsonArray array = element.getAsJsonArray();
        Metamodel metamodel = this.entityManager.getMetamodel();
        EntityType entity = metamodel.entity(elementType);
        javax.persistence.metamodel.Type idType = entity.getIdType();
        Class t = idType.getJavaType();
        SingularAttribute attribute = entity.getId(t);
        String fieldIdName = attribute.getName();
        for (JsonElement jsonElement : array) {
            Object object;
            try {
                Object o;
                object = o = this.newInstance(elementType);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SetterHandler handler = this.mirror.on(object).set();
            FieldSetter fieldSetter = handler.field(fieldIdName);
            fieldSetter.withValue((Object)jsonElement.getAsLong());
            collection.add(object);
        }
        return collection;
    }

    protected <Z, W> Z getInstance(Class<?> type) {
        AbstractCollection z = null;
        if (type.isAssignableFrom(List.class)) {
            z = new ArrayList();
        } else if (type.isAssignableFrom(Set.class)) {
            z = new HashSet();
        }
        return (Z)z;
    }

    protected String getPolymorphicTagName(Object model) {
        return "type";
    }

    protected String getPolymorphicTagValue(Object model) {
        String name = model.getClass().getSimpleName();
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

