/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.jpa.serializer;

import br.eti.clairton.jpa.serializer.Mode;
import br.eti.clairton.jpa.serializer.Node;
import br.eti.clairton.jpa.serializer.Nodes;
import br.eti.clairton.jpa.serializer.Operation;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractNodes
extends HashMap<String, Node>
implements Nodes {
    private static final long serialVersionUID = 1L;
    private final Node defaultNode;

    public AbstractNodes() {
        this.put("serialVersionUID", Mode.IGNORE);
        this.put("MIRROR", Mode.IGNORE);
        this.put("logger", Mode.IGNORE);
        this.put("STYLE", Mode.IGNORE);
        this.defaultNode = new Node(Mode.ID);
    }

    public AbstractNodes(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.put("serialVersionUID", Mode.IGNORE);
        this.put("MIRROR", Mode.IGNORE);
        this.put("logger", Mode.IGNORE);
        this.put("STYLE", Mode.IGNORE);
        this.defaultNode = new Node(Mode.ID);
    }

    @Override
    public void put(String key, Mode mode) {
        this.put(key, new Node(mode));
    }

    @Override
    public void put(String key, Mode mode, Operation operation) {
        this.put(key, new Node(mode, operation));
    }

    @Override
    public Boolean isReload(Object key) {
        return this.is(key, Mode.RELOAD);
    }

    @Override
    public Boolean isRecord(Object key) {
        return this.is(key, Mode.RECORD);
    }

    @Override
    public Boolean isId(Object key) {
        return this.is(key, Mode.ID) != false || this.isIdPolymorphic(key) != false;
    }

    @Override
    public Boolean isIdPolymorphic(Object key) {
        return this.is(key, Mode.ID_POLYMORPHIC);
    }

    @Override
    public Boolean isIdPolymorphic(Object key, Operation operation) {
        return this.is(key, Mode.ID_POLYMORPHIC, operation);
    }

    @Override
    public Boolean isIgnore(Object key) {
        return this.is(key, Mode.IGNORE);
    }

    @Override
    public Boolean is(Object key, Mode mode) {
        Node node = (Node)this.get(key);
        return node.getMode().equals((Object)mode) && node.getOperations().contains((Object)Operation.DESERIALIZE) && node.getOperations().contains((Object)Operation.SERIALIZE);
    }

    @Override
    public Boolean is(Object key, Mode mode, Operation operation) {
        Node node = (Node)this.get(key);
        return node.getMode().equals((Object)mode) && node.getOperations().contains((Object)operation);
    }

    @Override
    public Boolean isReload(Object key, Operation operation) {
        return this.is(key, Mode.RELOAD, operation);
    }

    @Override
    public Boolean isRecord(Object key, Operation operation) {
        return this.is(key, Mode.RECORD, operation);
    }

    @Override
    public Boolean isId(Object key, Operation operation) {
        return this.is(key, Mode.ID, operation) != false || this.isIdPolymorphic(key, operation) != false;
    }

    @Override
    public Boolean isIgnore(Object key, Operation operation) {
        return this.is(key, Mode.IGNORE, operation);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.values().iterator();
    }

    @Override
    public Node get(Object key, Operation operation) {
        Node node = (Node)this.get(key);
        if (node == null || !node.getOperations().contains((Object)operation)) {
            return this.getDefaulNode();
        }
        return node;
    }

    protected Node getDefaulNode() {
        return this.defaultNode;
    }
}

