/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.jcachepolicy;

import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public abstract class ExpiryCacheResolver
implements CacheResolver {
    protected final CacheManager manager;

    public ExpiryCacheResolver(CacheManager manager) {
        this.manager = manager;
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> context) {
        String name = context.getCacheName();
        return this.getCache(name);
    }

    protected Duration getDuration() {
        return new Duration(this.getTimeUnit(), (long)this.getQuantity().intValue());
    }

    protected <K, V> Factory<ExpiryPolicy> getFactory() {
        return AccessedExpiryPolicy.factoryOf((Duration)this.getDuration());
    }

    protected <K, V> Configuration<K, V> getConfiguration(String name) {
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setExpiryPolicyFactory(this.getFactory());
        return configuration;
    }

    protected <K, V> Cache<K, V> createCache(String name) {
        Configuration<K, V> configuration = this.getConfiguration(name);
        return this.manager.createCache(name, configuration);
    }

    private synchronized <K, V> Cache<K, V> getCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache == null) {
            return this.createCache(name);
        }
        return cache;
    }

    abstract TimeUnit getTimeUnit();

    abstract Integer getQuantity();
}

