/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.inflector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private final Collection<String> uncountable = new ArrayList<String>();
    private final Collection<Rule> singular = new ArrayList<Rule>();
    private final Map<String, String> irregular = new HashMap<String, String>();
    private final Collection<Rule> plural = new ArrayList<Rule>();
    private static final ThreadLocal<Map<String, Inflector>> INFLECTORS = new ThreadLocal<Map<String, Inflector>>(){
        private final Map<String, Inflector> map = new HashMap<String, Inflector>();
        {
            Inflector inflector = new Inflector();
            inflector.addSingular("^([a-zA-z]*)ais$/i", "\u0001al");
            inflector.addSingular("/^([a-zA-z]*)eis$/i", "\u0001el");
            inflector.addSingular("/^([a-zA-z]*)ois$/i", "\u0001ol");
            inflector.addSingular("/^([a-zA-z]*)uis$/i", "\u0001ul");
            inflector.addPlural("r$", "res");
            inflector.addPlural("\u00e3o$", "\u00f5es");
            inflector.addPlural("ao$", "oes");
            inflector.addPlural("vil$", "vis");
            inflector.addPlural("il$", "eis");
            inflector.addPlural("l$", "is");
            inflector.addPlural("z$", "zes");
            inflector.addPlural("m$", "ns");
            inflector.addPlural("$", "s");
            inflector.addSingular("res$", "r");
            inflector.addSingular("\u00f5es$", "\u00e3o");
            inflector.addSingular("oes$", "ao");
            inflector.addSingular("beis$", "bil");
            inflector.addSingular("vis$", "vil");
            inflector.addSingular("is$", "l");
            inflector.addSingular("zes$", "z");
            inflector.addSingular("ns$", "m");
            inflector.addSingular("s$", "");
            this.map.put("pt_BR", inflector);
        }

        @Override
        public Map<String, Inflector> get() {
            return this.map;
        }
    };

    public String singularize(String orig) {
        if (this.uncountable.contains(orig)) {
            return orig;
        }
        for (Map.Entry<String, String> entry : this.irregular.entrySet()) {
            if (!entry.getValue().equals(orig)) continue;
            return entry.getKey();
        }
        for (Rule r : this.singular) {
            Matcher m = r.regex.matcher(orig);
            if (!m.find()) continue;
            return m.replaceAll(r.replacement);
        }
        return orig;
    }

    public String replaceUpperedBy(String orig, String to) {
        String uncapitalized = this.uncapitalize(orig);
        Pattern pattern = Pattern.compile("[A-Z]");
        Matcher matcher = pattern.matcher(uncapitalized);
        StringBuilder builder = new StringBuilder();
        Integer start = 0;
        while (matcher.find()) {
            Integer end = matcher.end() - 1;
            String part = uncapitalized.substring(start, end);
            builder.append(part);
            builder.append(to);
            builder.append(Character.toLowerCase(uncapitalized.charAt(end)));
            start = matcher.end();
        }
        builder.append(uncapitalized.substring(start));
        return builder.toString();
    }

    public String dasherize(String orig) {
        return this.replaceUpperedBy(orig, "-");
    }

    public String underscore(String orig) {
        return this.replaceUpperedBy(orig, "_");
    }

    public String pluralize(String orig) {
        if (this.uncountable.contains(orig)) {
            return orig;
        }
        if (this.irregular.containsKey(orig)) {
            return this.irregular.get(orig);
        }
        for (Rule r : this.plural) {
            Matcher m = r.regex.matcher(orig);
            if (!m.find()) continue;
            return m.replaceAll(r.replacement);
        }
        return orig;
    }

    public String capitalize(String orig) {
        return Character.toUpperCase(orig.charAt(0)) + orig.substring(1);
    }

    public String uncapitalize(String orig) {
        return Character.toLowerCase(orig.charAt(0)) + orig.substring(1);
    }

    public void addPlural(String regex, String replacement) {
        this.plural.add(new Rule(regex, replacement));
    }

    public void addSingular(String regex, String replacement) {
        this.singular.add(new Rule(regex, replacement));
    }

    public void addIrregular(String orig, String replacement) {
        this.irregular.put(orig, replacement);
    }

    public void addUncountable(String[] words) {
        this.uncountable.addAll(Arrays.asList(words));
    }

    public void addUncountable(String word) {
        this.uncountable.add(word);
    }

    public static void addLocale(String locale, Inflector inflector) {
        INFLECTORS.get().put(locale, inflector);
    }

    public static Inflector getForLocale(String locale) {
        Inflector inflector;
        if (INFLECTORS.get().containsKey(locale)) {
            inflector = INFLECTORS.get().get(locale);
        } else {
            inflector = new Inflector();
            INFLECTORS.get().put(locale, inflector);
        }
        return inflector;
    }

    private static class Rule {
        private final Pattern regex;
        private final String replacement;

        public Rule(String regex, String replacement) {
            this.regex = Pattern.compile(regex, 2);
            this.replacement = replacement;
        }
    }
}

