/*
 * Decompiled with CFR 0.152.
 */
package br.com.maxicredito.ds.test;

import br.com.maxicredito.ds.test.Step;
import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;

public class DsStep
extends Step
implements Extension {
    private static final Logger logger = Logger.getLogger(DsStep.class.getName());

    @Override
    public void run() {
        logger.log(Level.FINE, "Criando do DataSources");
        try {
            InitialContext context = new InitialContext();
            String fileName = "datasources.properties";
            ClassLoader loader = this.getClass().getClassLoader();
            Enumeration<URL> resources = loader.getResources("datasources.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                Properties file = new Properties();
                file.load(stream);
                HashSet<String> names = new HashSet<String>();
                for (Map.Entry<Object, Object> entry : file.entrySet()) {
                    String value = entry.getValue().toString();
                    if (!value.equalsIgnoreCase("datasource")) continue;
                    names.add(entry.getKey().toString());
                }
                for (String name : names) {
                    HikariDataSource dataSource = new HikariDataSource();
                    dataSource.setDriverClassName(file.get(name + ".driver").toString());
                    dataSource.setJdbcUrl(file.get(name + ".url").toString());
                    dataSource.setUsername(file.get(name + ".username").toString());
                    dataSource.setPassword(file.get(name + ".password").toString());
                    String jndi = file.get(name + ".jndi").toString();
                    context.bind(jndi, (Object)dataSource);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

