/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.auth;

import javax.enterprise.context.RequestScoped;
import org.apache.shiro.authc.credential.PasswordService;
import org.mindrot.jbcrypt.BCrypt;

@RequestScoped
public class PasswordEncoder
implements PasswordService {
    private final int logRounds;

    public PasswordEncoder() {
        this.logRounds = 10;
    }

    public PasswordEncoder(int logRounds) {
        this.logRounds = logRounds;
    }

    public String encryptPassword(Object plaintextPassword) throws IllegalArgumentException {
        return BCrypt.hashpw((String)String.valueOf(plaintextPassword), (String)BCrypt.gensalt((int)this.logRounds));
    }

    public boolean passwordsMatch(Object submittedPlaintext, String encrypted) {
        return BCrypt.checkpw((String)String.valueOf((char[])submittedPlaintext), (String)encrypted);
    }

    public boolean passwordsMatch(String submittedPlaintext, String encrypted) {
        return BCrypt.checkpw((String)String.valueOf(submittedPlaintext), (String)encrypted);
    }

    public boolean passwordsMatch(char[] submittedPlaintext, String encrypted) {
        return BCrypt.checkpw((String)String.valueOf(submittedPlaintext), (String)encrypted);
    }

    public int getLogRounds() {
        return this.logRounds;
    }
}

