/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.config;

import br.eti.arthurgregorio.shiroee.auth.events.AuthenticationEventSupport;
import br.eti.arthurgregorio.shiroee.config.ConfigurationFactory;
import br.eti.arthurgregorio.shiroee.config.HttpSecurityConfiguration;
import br.eti.arthurgregorio.shiroee.config.RealmConfiguration;
import br.eti.arthurgregorio.shiroee.config.SecurityConfiguration;
import br.eti.arthurgregorio.shiroee.config.ldap.DefaultLdapUserProvider;
import br.eti.arthurgregorio.shiroee.config.ldap.LdapUserProvider;
import br.eti.arthurgregorio.shiroee.config.messages.Messages;
import br.eti.arthurgregorio.shiroee.realm.LdapSecurityRealm;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.Filter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;

@ApplicationScoped
public class DefaultSecurityConfiguration
implements SecurityConfiguration {
    private PropertiesConfiguration configuration = ConfigurationFactory.get();
    private LdapUserProvider ldapUserProvider;
    private LdapContextFactory ldapContextFactory;
    @Inject
    private AuthenticationEventSupport authenticationEventSupport;
    @Inject
    private Instance<RealmConfiguration> realmConfigurationInstance;
    @Inject
    private Instance<HttpSecurityConfiguration> httpSecurityConfigurationInstance;

    public DefaultSecurityConfiguration() {
        boolean ldapEnabled = this.configuration.getBoolean("ldap.enabled", false);
        if (ldapEnabled) {
            this.ldapContextFactory = this.configureLdapContextFactory();
            this.ldapUserProvider = this.configureLdapUserProvider();
        }
    }

    @Override
    public FilterChainResolver configurteFilterChainResolver() {
        DefaultFilterChainManager manager = new DefaultFilterChainManager();
        manager.addFilter(this.configuration.getString("operator.authenticated", "authc"), (Filter)this.configureFormAuthentication());
        manager.addFilter(this.configuration.getString("operator.logout", "logout"), (Filter)new LogoutFilter());
        manager.addFilter(this.configuration.getString("operator.anonymous", "anon"), (Filter)new AnonymousFilter());
        manager.addFilter(this.configuration.getString("operator.required_role", "roles"), (Filter)new RolesAuthorizationFilter());
        PermissionsAuthorizationFilter permsFilter = new PermissionsAuthorizationFilter();
        String Url401 = this.configuration.getString("url.unauthorized");
        if (StringUtils.isNotBlank((CharSequence)Url401)) {
            permsFilter.setUnauthorizedUrl(Url401);
        }
        manager.addFilter(this.configuration.getString("operator.required_permission", "perms"), (Filter)permsFilter);
        HttpSecurityConfiguration httpSecurityConfiguration = this.validateHttpConfig();
        Map<String, String> chains = httpSecurityConfiguration.configureHttpSecurity().build();
        chains.keySet().stream().forEach(arg_0 -> DefaultSecurityConfiguration.lambda$configurteFilterChainResolver$0((FilterChainManager)manager, chains, arg_0));
        this.destroy(httpSecurityConfiguration);
        manager.createChain(this.configuration.getString("url.root_secured_path", "/secured/**"), this.configuration.getString("operator.authenticated", "authc"));
        manager.createChain(this.configuration.getString("url.logout_path", "/logout"), this.configuration.getString("operator.logout", "logout"));
        PathMatchingFilterChainResolver resolver = new PathMatchingFilterChainResolver();
        resolver.setFilterChainManager((FilterChainManager)manager);
        return resolver;
    }

    @Override
    public DefaultWebSecurityManager configureSecurityManager() {
        this.validateRealmConfig();
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        CookieRememberMeManager rememberMeManager = new CookieRememberMeManager();
        rememberMeManager.setCipherKey(this.createCypherKey());
        RealmConfiguration realmConfiguration = this.validateRealmConfig();
        Set<Realm> realms = realmConfiguration.configureRealms();
        if (realms == null || realms.isEmpty()) {
            throw new ConfigurationException(Messages.NO_REALM_ERROR.format(new Object[0]));
        }
        this.destroy(realmConfiguration);
        securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
        ModularRealmAuthenticator authenticator = new ModularRealmAuthenticator();
        authenticator.setAuthenticationListeners((Collection)Lists.newArrayList((Object[])new AuthenticationListener[]{this.authenticationEventSupport}));
        securityManager.setAuthenticator((Authenticator)authenticator);
        realms.stream().filter(LdapSecurityRealm.class::isInstance).map(LdapSecurityRealm.class::cast).forEach(realm -> realm.setContextFactory(this.ldapContextFactory));
        securityManager.setRealms(realms);
        return securityManager;
    }

    @Produces
    @ApplicationScoped
    public LdapUserProvider produceLdapUserProvider() {
        if (this.ldapUserProvider == null) {
            this.configureLdapUserProvider();
        }
        return this.ldapUserProvider;
    }

    private LdapUserProvider configureLdapUserProvider() {
        String baseDn = this.configuration.getString("ldap.baseDn", "OU=Application,DC=br,DC=eti,DC=arthurgregorio");
        String searchFilter = this.configuration.getString("ldap.searchFilter", "(&(sAMAccountName={0})(objectclass=user))");
        return new DefaultLdapUserProvider(baseDn, searchFilter, this.ldapContextFactory);
    }

    private LdapContextFactory configureLdapContextFactory() {
        JndiLdapContextFactory factory = new JndiLdapContextFactory();
        String ldapUrl = (String)Preconditions.checkNotNull((Object)this.configuration.getString("ldap.url"));
        String ldapUser = (String)Preconditions.checkNotNull((Object)this.configuration.getString("ldap.user"));
        String ldapPassword = (String)Preconditions.checkNotNull((Object)this.configuration.getString("ldap.password"));
        factory.setUrl(ldapUrl);
        factory.setSystemUsername(ldapUser);
        factory.setSystemPassword(ldapPassword);
        factory.setPoolingEnabled(true);
        return factory;
    }

    private FormAuthenticationFilter configureFormAuthentication() {
        FormAuthenticationFilter formAuthenticator = new FormAuthenticationFilter();
        formAuthenticator.setLoginUrl(this.configuration.getString("url.login", "/index"));
        formAuthenticator.setSuccessUrl(this.configuration.getString("url.login_success", "/secured/index"));
        return formAuthenticator;
    }

    private byte[] createCypherKey() {
        return String.format("0x%s", Hex.encodeToString((byte[])new AesCipherService().generateNewKey().getEncoded())).getBytes();
    }

    private HttpSecurityConfiguration validateHttpConfig() {
        if (!this.httpSecurityConfigurationInstance.isUnsatisfied() && !this.httpSecurityConfigurationInstance.isAmbiguous()) {
            return (HttpSecurityConfiguration)this.httpSecurityConfigurationInstance.get();
        }
        throw new ConfigurationException(Messages.INSTANCE_IS_INVALID.format("HttpSecurityConfigurationInstance"));
    }

    private RealmConfiguration validateRealmConfig() {
        if (!this.realmConfigurationInstance.isUnsatisfied() && !this.realmConfigurationInstance.isAmbiguous()) {
            return (RealmConfiguration)this.realmConfigurationInstance.get();
        }
        throw new ConfigurationException(Messages.INSTANCE_IS_INVALID.format("RealmConfiguration"));
    }

    private void destroy(RealmConfiguration instance) {
        this.realmConfigurationInstance.destroy((Object)instance);
    }

    private void destroy(HttpSecurityConfiguration instance) {
        this.httpSecurityConfigurationInstance.destroy((Object)instance);
    }

    private static /* synthetic */ void lambda$configurteFilterChainResolver$0(FilterChainManager manager, Map chains, String path) {
        manager.createChain(path, (String)chains.get(path));
    }
}

