/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.realm;

import br.eti.arthurgregorio.shiroee.auth.AuthenticationMechanism;
import br.eti.arthurgregorio.shiroee.auth.PasswordEncoder;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetails;
import br.eti.arthurgregorio.shiroee.config.messages.Messages;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class JdbcSecurityRealm
extends AuthorizingRealm {
    private final AuthenticationMechanism<? extends UserDetails> mechanism;

    public JdbcSecurityRealm(AuthenticationMechanism<? extends UserDetails> mechanism) {
        this.mechanism = mechanism;
        PasswordMatcher passwordMatcher = new PasswordMatcher();
        passwordMatcher.setPasswordService((PasswordService)new PasswordEncoder());
        super.setCredentialsMatcher((CredentialsMatcher)passwordMatcher);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        UserDetails userDetails = this.mechanism.getAccount(token.getUsername());
        if (!userDetails.isLdapBindAccount() && !userDetails.isBlocked()) {
            return new SimpleAuthenticationInfo(userDetails.getUsername(), userDetails.getPassword(), this.getName());
        }
        throw new AuthenticationException(Messages.AUTHENTICATION_ERROR.format(token.getUsername()));
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        String username = (String)this.getAvailablePrincipal(principalCollection);
        SimpleAuthorizationInfo authzInfo = new SimpleAuthorizationInfo();
        authzInfo.setStringPermissions(this.mechanism.getPermissions(username));
        return authzInfo;
    }
}

