/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.auth;

import br.eti.arthurgregorio.shiroee.auth.AuthenticationMechanism;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetails;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetailsProvider;
import br.eti.arthurgregorio.shiroee.config.messages.Messages;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;

public class DatabaseAuthenticationMechanism
implements AuthenticationMechanism<UserDetails> {
    private final UserDetailsProvider userDetailsProvider;

    public DatabaseAuthenticationMechanism(UserDetailsProvider userDetailsProvider) {
        this.userDetailsProvider = (UserDetailsProvider)Preconditions.checkNotNull((Object)userDetailsProvider);
    }

    @Override
    public UserDetails getAccount(String username) {
        return this.userDetailsProvider.findUserDetailsByUsername(username).orElseThrow(() -> new AuthenticationException(Messages.ACCOUNT_NOT_FOUND.format(username)));
    }

    @Override
    public Set<String> getPermissions(String username) {
        UserDetails userDetails = this.userDetailsProvider.findUserDetailsByUsername(username).orElseThrow(() -> new AuthenticationException(Messages.ACCOUNT_NOT_FOUND.format(username)));
        return userDetails.getPermissions();
    }
}

