/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.config.ldap;

import br.eti.arthurgregorio.shiroee.config.ldap.LdapUser;
import br.eti.arthurgregorio.shiroee.config.ldap.LdapUserProvider;
import br.eti.arthurgregorio.shiroee.config.messages.Messages;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.realm.ldap.LdapContextFactory;

public class DefaultLdapUserProvider
implements LdapUserProvider {
    private final String baseDN;
    private final String searchFilter;
    private LdapContextFactory ldapContextFactory;

    public DefaultLdapUserProvider(String baseDN, String searchFilter) {
        this.baseDN = (String)Preconditions.checkNotNull((Object)baseDN);
        this.searchFilter = (String)Preconditions.checkNotNull((Object)searchFilter);
    }

    public DefaultLdapUserProvider(String baseDN, String searchFilter, LdapContextFactory ldapContextFactory) {
        this(baseDN, searchFilter);
        this.ldapContextFactory = (LdapContextFactory)Preconditions.checkNotNull((Object)ldapContextFactory);
    }

    @Override
    public Optional<LdapUser> search(String principal) {
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            LdapContext context = this.ldapContextFactory.getSystemLdapContext();
            NamingEnumeration<SearchResult> answer = context.search(this.baseDN, this.searchFilter, new Object[]{principal}, searchControls);
            if (answer.hasMoreElements()) {
                SearchResult result = answer.next();
                Attributes attributes = result.getAttributes();
                return Optional.of(LdapUser.of(attributes));
            }
        }
        catch (NamingException ex) {
            throw new AuthenticationException(Messages.BIND_ERROR.format(principal));
        }
        return Optional.empty();
    }

    @Override
    public void setLdapContextFactory(LdapContextFactory ldapContextFactory) {
        this.ldapContextFactory = ldapContextFactory;
    }
}

