package kotlinjs.runtime.decorator

internal fun decorate(decorators: Array<out Decorator>, target: Any, propertyName: String? = null): Any? {
    return js("""
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };

    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };

    if (propertyName) {
        return __decorate(decorators, target.prototype, propertyName, Object.getOwnPropertyDescriptor(target.prototype, propertyName));
    }

    return __decorate(decorators, target);
    """)
}

fun <T> JsClass<T>.addClassDecorators(decorators: Array<out ClassDecorator>): JsClass<T> {
    val type = this
    val result = decorate(decorators, type)

    return js("(result)")
}
