package kotlinjs.runtime

import kotlinjs.runtime.decorator.ClassDecorator
import kotlinjs.runtime.decorator.addClassDecorators

class TypeInfo<T>(val fullName: String,
                  val simpleName: String,
                  type: JsType<T>) {

    val typePrototype: T
        get() {
            return type.asDynamic().prototype
        }

    var type: JsType<T> = type
        get
        private set

    fun decorate(vararg decorators: ClassDecorator) {
        type = type.addClassDecorators(decorators)
    }

}


fun <T> typeInfo(creator: () -> T): TypeInfo<T>? {
    val creatorString = creator.toString()
    val pattern = Regex("""new (.*)\(""")
    val match = pattern.find(creatorString) ?: return null
    val resolutionPath = match.groupValues[1]
    val typeName = resolutionPath.substring(2)

    val simpleName =
            if (typeName.contains(".")) {
                val index = typeName.lastIndexOf('.')
                typeName.substring(index + 1)
            } else {
                typeName
            }

    val type: JsType<T> = js("(eval(resolutionPath))")

    return TypeInfo(typeName, simpleName, type)
}
