package kotlinjs.runtime

data class TypeInfo<out T>(val fullName: String,
                           val simpleName: String,
                           val type: JsType<T>,
                           val typePrototype: Any)


fun <T> typeInfo(creator: () -> T): TypeInfo<T>? {
    val creatorString = creator.toString()
    val pattern = Regex("""new (.*)\(""")
    val match = pattern.find(creatorString) ?: return null
    val resolutionPath = match.groupValues[1]
    val typeName = resolutionPath.substring(2)

    val simpleName =
            if (typeName.contains(".")) {
                val index = typeName.lastIndexOf('.')
                typeName.substring(index + 1)
            } else {
                typeName
            }

    val type: JsType<T> = js("(eval(resolutionPath))")
    val typePrototype: Any = js("(type.prototype)")

    return TypeInfo(typeName, simpleName, type, typePrototype)
}
